/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.rolemapping;

import java.util.Optional;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ReservedStateAwareHandledTransportAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingResponse;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;

public class TransportDeleteRoleMappingAction
extends ReservedStateAwareHandledTransportAction<DeleteRoleMappingRequest, DeleteRoleMappingResponse> {
    private final NativeRoleMappingStore roleMappingStore;

    @Inject
    public TransportDeleteRoleMappingAction(ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, NativeRoleMappingStore roleMappingStore) {
        super("cluster:admin/xpack/security/role_mapping/delete", clusterService, transportService, actionFilters, DeleteRoleMappingRequest::new);
        this.roleMappingStore = roleMappingStore;
    }

    protected void doExecuteProtected(Task task, DeleteRoleMappingRequest request, ActionListener<DeleteRoleMappingResponse> listener) {
        this.roleMappingStore.deleteRoleMapping(request, (ActionListener<Boolean>)listener.delegateFailure((l, found) -> l.onResponse((Object)new DeleteRoleMappingResponse(found.booleanValue()))));
    }

    public Optional<String> reservedStateHandlerName() {
        return Optional.of("role_mappings");
    }

    public Set<String> modifiedKeys(DeleteRoleMappingRequest request) {
        return Set.of(request.getName());
    }
}

