/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.saml;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionRequest;
import org.elasticsearch.xpack.core.security.action.saml.SamlInvalidateSessionResponse;
import org.elasticsearch.xpack.core.security.authc.support.TokensInvalidationResult;
import org.elasticsearch.xpack.security.authc.Realms;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;
import org.elasticsearch.xpack.security.authc.saml.SamlLogoutRequestHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlRealm;
import org.elasticsearch.xpack.security.authc.saml.SamlRedirect;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.StatusResponseType;

public final class TransportSamlInvalidateSessionAction
extends HandledTransportAction<SamlInvalidateSessionRequest, SamlInvalidateSessionResponse> {
    private final TokenService tokenService;
    private final Realms realms;

    @Inject
    public TransportSamlInvalidateSessionAction(TransportService transportService, ActionFilters actionFilters, TokenService tokenService, Realms realms) {
        super("cluster:admin/xpack/security/saml/invalidate", transportService, actionFilters, SamlInvalidateSessionRequest::new);
        this.tokenService = tokenService;
        this.realms = realms;
    }

    protected void doExecute(Task task, SamlInvalidateSessionRequest request, ActionListener<SamlInvalidateSessionResponse> listener) {
        List<SamlRealm> realms = SamlRealm.findSamlRealms(this.realms, request.getRealmName(), request.getAssertionConsumerServiceURL());
        if (realms.isEmpty()) {
            listener.onFailure((Exception)SamlUtils.samlException("Cannot find any matching realm for [{}]", request));
        } else if (realms.size() > 1) {
            listener.onFailure((Exception)SamlUtils.samlException("Found multiple matching realms [{}] for [{}]", realms, request));
        } else {
            this.invalidateSession(realms.get(0), request, listener);
        }
    }

    private void invalidateSession(SamlRealm realm, SamlInvalidateSessionRequest request, ActionListener<SamlInvalidateSessionResponse> listener) {
        try {
            SamlLogoutRequestHandler.Result result = realm.getLogoutHandler().parseFromQueryString(request.getQueryString());
            this.findAndInvalidateTokens(realm, result, (ActionListener<Integer>)ActionListener.wrap(count -> listener.onResponse((Object)new SamlInvalidateSessionResponse(realm.name(), count.intValue(), this.buildLogoutResponseUrl(realm, result))), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (ElasticsearchSecurityException e) {
            this.logger.info("Failed to invalidate SAML session", (Throwable)e);
            listener.onFailure((Exception)((Object)e));
        }
    }

    private String buildLogoutResponseUrl(SamlRealm realm, SamlLogoutRequestHandler.Result result) {
        LogoutResponse response = realm.buildLogoutResponse(result.getRequestId());
        return new SamlRedirect((StatusResponseType)response, realm.getSigningConfiguration()).getRedirectUrl(result.getRelayState());
    }

    private void findAndInvalidateTokens(SamlRealm realm, SamlLogoutRequestHandler.Result result, ActionListener<Integer> listener) {
        Map<String, Object> tokenMetadata = realm.createTokenMetadata(result.getNameId(), result.getSession());
        if (Strings.isNullOrEmpty((String)((String)tokenMetadata.get("saml_nameid_val")))) {
            this.logger.debug("Logout request [{}] has no NameID value, so cannot invalidate any sessions", (Object)result);
            listener.onResponse((Object)0);
            return;
        }
        this.tokenService.findActiveTokensForRealm(realm.name(), this.containsMetadata(tokenMetadata), (ActionListener<Collection<Tuple<UserToken, String>>>)ActionListener.wrap(tokens -> {
            this.logger.debug("Found [{}] token pairs to invalidate for SAML metadata [{}]", (Object)tokens.size(), (Object)tokenMetadata);
            if (tokens.isEmpty()) {
                listener.onResponse((Object)0);
            } else {
                GroupedActionListener groupedListener = new GroupedActionListener(tokens.size(), ActionListener.wrap(collection -> listener.onResponse((Object)collection.size()), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                tokens.forEach(tuple -> this.invalidateTokenPair((Tuple<UserToken, String>)tuple, (ActionListener<TokensInvalidationResult>)groupedListener));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void invalidateTokenPair(Tuple<UserToken, String> tokenPair, ActionListener<TokensInvalidationResult> listener) {
        if (tokenPair.v2() != null) {
            this.tokenService.invalidateRefreshToken((String)tokenPair.v2(), (ActionListener<TokensInvalidationResult>)ActionListener.wrap(ignore -> this.invalidateAccessToken((UserToken)tokenPair.v1(), listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.invalidateAccessToken((UserToken)tokenPair.v1(), listener);
        }
    }

    private void invalidateAccessToken(UserToken userToken, ActionListener<TokensInvalidationResult> listener) {
        this.tokenService.invalidateAccessToken(userToken, (ActionListener<TokensInvalidationResult>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            this.logger.info("Failed to invalidate SAML access_token [{}] - {}", (Object)userToken.getId(), (Object)e.toString());
            listener.onFailure(e);
        }));
    }

    private Predicate<Map<String, Object>> containsMetadata(Map<String, Object> requiredMetadata) {
        return source -> {
            Map actualMetadata = (Map)source.get("metadata");
            return requiredMetadata.entrySet().stream().allMatch(e -> Objects.equals(actualMetadata.get(e.getKey()), e.getValue()));
        };
    }
}

