/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.index;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class IndexNameResolver {
    private IndexNameResolver() {
    }

    public static String resolve(ZonedDateTime timestamp, Rollover rollover) {
        return rollover.formatter().format(timestamp);
    }

    public static String resolve(String indexNamePrefix, ZonedDateTime timestamp, Rollover rollover) {
        return indexNamePrefix + IndexNameResolver.resolve(timestamp, rollover);
    }

    public static enum Rollover {
        HOURLY("-yyyy.MM.dd.HH"),
        DAILY("-yyyy.MM.dd"),
        WEEKLY("-yyyy.w"),
        MONTHLY("-yyyy.MM");

        private final DateTimeFormatter formatter;

        private Rollover(String format) {
            this.formatter = DateTimeFormatter.ofPattern(format, Locale.ROOT);
        }

        DateTimeFormatter formatter() {
            return this.formatter;
        }
    }
}

