/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

final class ExpiredTokenRemover
extends AbstractRunnable {
    private static final Logger logger = LogManager.getLogger(ExpiredTokenRemover.class);
    public static final long MAXIMUM_TOKEN_LIFETIME_HOURS = 24L;
    private final Client client;
    private final SecurityIndexManager securityMainIndex;
    private final SecurityIndexManager securityTokensIndex;
    private final AtomicBoolean inProgress;
    private final TimeValue timeout;
    private boolean checkMainIndexForExpiredTokens;

    ExpiredTokenRemover(Settings settings, Client client, SecurityIndexManager securityMainIndex, SecurityIndexManager securityTokensIndex) {
        this.client = client;
        this.securityMainIndex = securityMainIndex;
        this.securityTokensIndex = securityTokensIndex;
        this.inProgress = new AtomicBoolean(false);
        this.timeout = (TimeValue)TokenService.DELETE_TIMEOUT.get(settings);
        this.checkMainIndexForExpiredTokens = true;
    }

    public void doRun() {
        ArrayList<String> indicesWithTokens = new ArrayList<String>();
        if (this.securityTokensIndex.isAvailable()) {
            indicesWithTokens.add(this.securityTokensIndex.aliasName());
        }
        if (this.securityMainIndex.isAvailable() && this.checkMainIndexForExpiredTokens) {
            indicesWithTokens.add(this.securityMainIndex.aliasName());
        }
        if (indicesWithTokens.isEmpty()) {
            this.markComplete();
            return;
        }
        DeleteByQueryRequest expiredDbq = new DeleteByQueryRequest(indicesWithTokens.toArray(new String[0]));
        if (this.timeout != TimeValue.MINUS_ONE) {
            expiredDbq.setTimeout(this.timeout);
            expiredDbq.getSearchRequest().source().timeout(this.timeout);
        }
        Instant now = Instant.now();
        expiredDbq.setQuery((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termsQuery((String)"doc_type", (String[])new String[]{"token"})).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"creation_time").lte((Object)now.minus(24L, ChronoUnit.HOURS).toEpochMilli())));
        logger.trace(() -> "Removing old tokens: [" + org.elasticsearch.common.Strings.toString((ToXContent)expiredDbq) + "]");
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)expiredDbq, (ActionListener)ActionListener.wrap(bulkResponse -> {
            ExpiredTokenRemover.debugDbqResponse(bulkResponse);
            if (this.checkMainIndexForExpiredTokens && this.securityTokensIndex.indexExists() && this.securityTokensIndex.getCreationTime().isBefore(now.minus(24L, ChronoUnit.HOURS)) && bulkResponse.getBulkFailures().isEmpty() && bulkResponse.getSearchFailures().isEmpty()) {
                this.checkMainIndexForExpiredTokens = false;
            }
            this.markComplete();
        }, this::onFailure));
    }

    void submit(ThreadPool threadPool) {
        if (this.inProgress.compareAndSet(false, true)) {
            threadPool.executor("generic").submit((Runnable)((Object)this));
        }
    }

    private static void debugDbqResponse(BulkByScrollResponse response) {
        if (logger.isDebugEnabled()) {
            logger.debug("delete by query of tokens finished with [{}] deletions, [{}] bulk failures, [{}] search failures", (Object)response.getDeleted(), (Object)response.getBulkFailures().size(), (Object)response.getSearchFailures().size());
            for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                logger.debug(() -> Strings.format((String)"deletion failed for index [%s], id [%s]", (Object[])new Object[]{failure.getIndex(), failure.getId()}), (Throwable)failure.getCause());
            }
            for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                logger.debug(() -> ExpiredTokenRemover.lambda$debugDbqResponse$3((ScrollableHitSource.SearchFailure)failure), failure.getReason());
            }
        }
    }

    boolean isExpirationInProgress() {
        return this.inProgress.get();
    }

    public void onFailure(Exception e) {
        if (TransportActions.isShardNotAvailableException((Throwable)e)) {
            logger.debug("failed to delete expired tokens", (Throwable)e);
        } else {
            logger.error("failed to delete expired tokens", (Throwable)e);
        }
        this.markComplete();
    }

    private void markComplete() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new IllegalStateException("in progress was set to false but should have been true!");
        }
    }

    private static /* synthetic */ Object lambda$debugDbqResponse$3(ScrollableHitSource.SearchFailure failure) {
        return Strings.format((String)"search failed for index [%s], shard [%s] on node [%s]", (Object[])new Object[]{failure.getIndex(), failure.getShardId(), failure.getNodeId()});
    }
}

