/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.saml;

import java.time.Clock;
import java.util.Objects;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.security.authc.saml.IdpConfiguration;
import org.elasticsearch.xpack.security.authc.saml.SamlNameId;
import org.elasticsearch.xpack.security.authc.saml.SamlObjectHandler;
import org.elasticsearch.xpack.security.authc.saml.SamlUtils;
import org.elasticsearch.xpack.security.authc.saml.SpConfiguration;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Element;

public class SamlLogoutRequestHandler
extends SamlObjectHandler {
    private static final String REQUEST_TAG_NAME = "LogoutRequest";

    SamlLogoutRequestHandler(Clock clock, IdpConfiguration idp, SpConfiguration sp, TimeValue maxSkew) {
        super(clock, idp, sp, maxSkew);
    }

    public Result parseFromQueryString(String queryString) {
        SamlObjectHandler.ParsedQueryString parsed = this.parseQueryStringAndValidateSignature(queryString, "SAMLRequest");
        Element root = this.parseSamlMessage(this.inflate(this.decodeBase64(parsed.samlMessage)));
        if (REQUEST_TAG_NAME.equals(root.getLocalName()) && "urn:oasis:names:tc:SAML:2.0:protocol".equals(root.getNamespaceURI())) {
            try {
                LogoutRequest logoutRequest = this.buildXmlObject(root, LogoutRequest.class);
                return this.parseLogout(logoutRequest, !parsed.hasSignature, parsed.relayState);
            }
            catch (ElasticsearchSecurityException e) {
                this.logger.trace("Rejecting SAML logout request {} because {}", (Object)SamlUtils.toString(root), (Object)e.getMessage());
                throw e;
            }
        }
        throw SamlUtils.samlException("SAML content [{}] should have a root element of Namespace=[{}] Tag=[{}]", root, "urn:oasis:names:tc:SAML:2.0:protocol", REQUEST_TAG_NAME);
    }

    private Result parseLogout(LogoutRequest logoutRequest, boolean requireSignature, String relayState) {
        Signature signature = logoutRequest.getSignature();
        if (signature == null) {
            if (requireSignature) {
                throw SamlUtils.samlException("Logout request is not signed", new Object[0]);
            }
        } else {
            this.validateSignature(signature);
        }
        this.checkIssuer(logoutRequest.getIssuer(), (XMLObject)logoutRequest);
        this.checkDestination(logoutRequest);
        this.validateNotOnOrAfter(logoutRequest.getNotOnOrAfter());
        return new Result(logoutRequest.getID(), SamlNameId.fromXml(this.getNameID(logoutRequest)), this.getSessionIndex(logoutRequest), relayState);
    }

    private NameID getNameID(LogoutRequest logoutRequest) {
        SAMLObject samlObject;
        EncryptedID encryptedID;
        NameID nameID = logoutRequest.getNameID();
        if (nameID == null && (encryptedID = logoutRequest.getEncryptedID()) != null && (samlObject = this.decrypt(encryptedID)) instanceof NameID) {
            return (NameID)samlObject;
        }
        return nameID;
    }

    private SAMLObject decrypt(EncryptedID encrypted) {
        if (this.decrypter == null) {
            throw SamlUtils.samlException("SAML EncryptedID [" + this.text((XMLObject)encrypted, 32) + "] is encrypted, but no decryption key is available", new Object[0]);
        }
        try {
            return this.decrypter.decrypt(encrypted);
        }
        catch (DecryptionException e) {
            this.logger.debug(() -> Strings.format((String)"Failed to decrypt SAML EncryptedID [%s] with [%s]", (Object[])new Object[]{this.text((XMLObject)encrypted, 512), this.describe(this.getSpConfiguration().getEncryptionCredentials())}), (Throwable)e);
            throw SamlUtils.samlException("Failed to decrypt SAML EncryptedID " + this.text((XMLObject)encrypted, 32), (Exception)((Object)e), new Object[0]);
        }
    }

    private String getSessionIndex(LogoutRequest logoutRequest) {
        return logoutRequest.getSessionIndexes().stream().map(as -> as.getValue()).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void checkDestination(LogoutRequest request) {
        String url = this.getSpConfiguration().getLogoutUrl();
        if (url == null) {
            throw SamlUtils.samlException("SAML request " + request.getID() + " is for destination " + request.getDestination() + " but this realm is not configured for logout", new Object[0]);
        }
        if (!url.equals(request.getDestination())) {
            throw SamlUtils.samlException("SAML request " + request.getID() + " is for destination " + request.getDestination() + " but this realm uses " + url, new Object[0]);
        }
    }

    public static class Result {
        private final String requestId;
        private final SamlNameId nameId;
        private final String session;
        private final String relayState;

        public Result(String requestId, SamlNameId nameId, String session, String relayState) {
            this.requestId = requestId;
            this.nameId = nameId;
            this.session = session;
            this.relayState = relayState;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public SamlNameId getNameId() {
            return this.nameId;
        }

        public String getSession() {
            return this.session;
        }

        public String getRelayState() {
            return this.relayState;
        }

        public String toString() {
            return "SamlLogoutRequestHandler.Result{requestId='" + this.requestId + "', nameId=" + this.nameId + ", session='" + this.session + "', relayState='" + this.relayState + "'}";
        }
    }
}

