/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.interceptor;

import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.interceptor.FieldAndDocumentLevelSecurityRequestInterceptor;

public class SearchRequestInterceptor
extends FieldAndDocumentLevelSecurityRequestInterceptor {
    private final ClusterService clusterService;

    public SearchRequestInterceptor(ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService) {
        super(threadPool.getThreadContext(), licenseState);
        this.clusterService = clusterService;
    }

    @Override
    void disableFeatures(IndicesRequest indicesRequest, Map<String, IndicesAccessControl.IndexAccessControl> indexAccessControlByIndex, ActionListener<Void> listener) {
        SearchRequest request = (SearchRequest)indicesRequest;
        if (indexAccessControlByIndex.values().stream().anyMatch(iac -> iac.getDocumentPermissions().hasDocumentLevelPermissions())) {
            if (SearchRequestInterceptor.hasSuggest(request)) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("Suggest isn't supported if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else if (SearchRequestInterceptor.hasProfile(request)) {
                listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("A search request cannot be profiled if document level security is enabled", RestStatus.BAD_REQUEST, new Object[0])));
            } else {
                listener.onResponse(null);
            }
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public boolean supports(IndicesRequest request) {
        if (request instanceof SearchRequest) {
            SearchRequest searchRequest = (SearchRequest)request;
            return SearchRequestInterceptor.hasSuggest(searchRequest) || SearchRequestInterceptor.hasProfile(searchRequest);
        }
        return false;
    }

    private static boolean hasSuggest(SearchRequest searchRequest) {
        return searchRequest.source() != null && searchRequest.source().suggest() != null;
    }

    private static boolean hasProfile(SearchRequest searchRequest) {
        return searchRequest.source() != null && searchRequest.source().profile();
    }
}

