/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestHasPrivilegesAction
extends SecurityBaseRestHandler {
    private final SecurityContext securityContext;

    public RestHasPrivilegesAction(Settings settings, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/user/{username}/_has_privileges").replaces(RestRequest.Method.GET, "/_xpack/security/user/{username}/_has_privileges", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/{username}/_has_privileges").replaces(RestRequest.Method.POST, "/_xpack/security/user/{username}/_has_privileges", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_security/user/_has_privileges").replaces(RestRequest.Method.GET, "/_xpack/security/user/_has_privileges", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/user/_has_privileges").replaces(RestRequest.Method.POST, "/_xpack/security/user/_has_privileges", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_has_privileges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        Tuple content = request.contentOrSourceParam();
        String username = this.getUsername(request);
        if (username == null) {
            return restChannel -> {
                throw new ElasticsearchSecurityException("there is no authenticated user", new Object[0]);
            };
        }
        HasPrivilegesRequestBuilder requestBuilder = new HasPrivilegesRequestBuilder((ElasticsearchClient)client).source(username, (BytesReference)content.v2(), (XContentType)content.v1());
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<HasPrivilegesResponse>(channel){

            public RestResponse buildResponse(HasPrivilegesResponse response, XContentBuilder builder) throws Exception {
                response.toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new RestResponse(RestStatus.OK, builder);
            }
        });
    }

    private String getUsername(RestRequest request) {
        String username = request.param("username");
        if (username != null) {
            return username;
        }
        User user = this.securityContext.getUser();
        if (user == null) {
            return null;
        }
        return user.principal();
    }
}

