/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.cayc.ws;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.utils.text.JsonWriter;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Issues;
import org.sonarqube.ws.client.WsClient;
import org.sonarqube.ws.client.WsClientFactories;
import org.sonarqube.ws.client.issues.SearchRequest;

public class CAYCChartDataRequestHandler
implements RequestHandler {
    private static final int MAX_YEARS = 15;
    private WsClient wsClient;

    public CAYCChartDataRequestHandler() {
    }

    public CAYCChartDataRequestHandler(WsClient wsClient) {
        this.wsClient = wsClient;
    }

    public void handle(Request request, Response response) {
        this.initialiseWsClient(request);
        CAYCChartDataRequestHandler.writeResponse(response, this.issuesCreatedHistogram());
    }

    private List<Common.FacetValue> issuesCreatedHistogram() {
        boolean found = false;
        ArrayList<Common.FacetValue> result = new ArrayList<Common.FacetValue>();
        for (int i = 14; i >= 0; --i) {
            LocalDate year = CAYCChartDataRequestHandler.getDateMinusYear(i);
            SearchRequest request = this.yearlyCreatedIssuesSearchRequest(year);
            Issues.SearchWsResponse response = this.wsClient.issues().search(request);
            if (!found && response.getTotal() <= 0L) continue;
            found = true;
            result.addAll(response.getFacets().getFacets(0).getValuesList());
        }
        Collections.sort(result, Comparator.comparing(Common.FacetValue::getVal));
        return result;
    }

    private static LocalDate getDateMinusYear(int year) {
        LocalDate currentYear = LocalDate.now();
        return currentYear.minusYears(year);
    }

    private SearchRequest yearlyCreatedIssuesSearchRequest(LocalDate date) {
        return new SearchRequest().setCreatedAfter(this.isoFormat(date.minusYears(1L))).setCreatedBefore(this.isoFormat(date)).setTypes(List.of(RuleType.BUG.name(), RuleType.VULNERABILITY.name())).setResolved(Boolean.FALSE.toString()).setFacets(List.of("createdAt"));
    }

    private String isoFormat(LocalDate date) {
        return date.format(DateTimeFormatter.ISO_DATE);
    }

    private void initialiseWsClient(Request request) {
        if (this.wsClient == null) {
            this.wsClient = WsClientFactories.getLocal().newClient(request.localConnector());
        }
    }

    private static void writeResponse(Response response, List<Common.FacetValue> facetValues) {
        try (JsonWriter json = response.newJsonWriter();){
            json.beginObject().name("history").beginArray();
            facetValues.forEach(v -> json.beginObject().prop("date", v.getVal()).prop("value", v.getCount()).endObject());
            json.endArray().endObject().close();
        }
    }
}

