/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiler;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.profiler.StackFrame;
import org.elasticsearch.xpack.profiler.StackTrace;

public class GetProfilingResponse
extends ActionResponse
implements StatusToXContentObject {
    @Nullable
    private final Map<String, StackTrace> stackTraces;
    @Nullable
    private final Map<String, StackFrame> stackFrames;
    @Nullable
    private final Map<String, String> executables;
    @Nullable
    private final Map<String, Integer> stackTraceEvents;
    private final int totalFrames;
    @Nullable
    private final Exception error;

    public GetProfilingResponse(StreamInput in) throws IOException {
        this.stackTraces = in.readBoolean() ? in.readMap(StreamInput::readString, i -> new StackTrace(i.readList(StreamInput::readInt), i.readList(StreamInput::readString), i.readList(StreamInput::readString), i.readList(StreamInput::readInt))) : null;
        this.stackFrames = in.readBoolean() ? in.readMap(StreamInput::readString, i -> new StackFrame(i.readList(StreamInput::readString), i.readList(StreamInput::readString), i.readList(StreamInput::readInt), i.readList(StreamInput::readInt), i.readList(StreamInput::readInt))) : null;
        this.executables = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readString) : null;
        this.stackTraceEvents = in.readBoolean() ? in.readMap(StreamInput::readString, StreamInput::readInt) : null;
        this.totalFrames = in.readInt();
        this.error = in.readBoolean() ? in.readException() : null;
    }

    public GetProfilingResponse(Map<String, StackTrace> stackTraces, Map<String, StackFrame> stackFrames, Map<String, String> executables, Map<String, Integer> stackTraceEvents, int totalFrames) {
        this(stackTraces, stackFrames, executables, stackTraceEvents, totalFrames, null);
    }

    public GetProfilingResponse(Exception error) {
        this(null, null, null, null, 0, error);
    }

    private GetProfilingResponse(Map<String, StackTrace> stackTraces, Map<String, StackFrame> stackFrames, Map<String, String> executables, Map<String, Integer> stackTraceEvents, int totalFrames, Exception error) {
        this.stackTraces = stackTraces;
        this.stackFrames = stackFrames;
        this.executables = executables;
        this.stackTraceEvents = stackTraceEvents;
        this.totalFrames = totalFrames;
        this.error = error;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.stackTraces != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraces, StreamOutput::writeString, (o, v) -> {
                o.writeCollection(v.addressOrLines, StreamOutput::writeInt);
                o.writeCollection(v.fileIds, StreamOutput::writeString);
                o.writeCollection(v.frameIds, StreamOutput::writeString);
                o.writeCollection(v.typeIds, StreamOutput::writeInt);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.stackFrames != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackFrames, StreamOutput::writeString, (o, v) -> {
                o.writeCollection(v.fileName, StreamOutput::writeString);
                o.writeCollection(v.functionName, StreamOutput::writeString);
                o.writeCollection(v.functionOffset, StreamOutput::writeInt);
                o.writeCollection(v.lineNumber, StreamOutput::writeInt);
                o.writeCollection(v.sourceType, StreamOutput::writeInt);
            });
        } else {
            out.writeBoolean(false);
        }
        if (this.executables != null) {
            out.writeBoolean(true);
            out.writeMap(this.executables, StreamOutput::writeString, StreamOutput::writeString);
        } else {
            out.writeBoolean(false);
        }
        if (this.stackTraceEvents != null) {
            out.writeBoolean(true);
            out.writeMap(this.stackTraceEvents, StreamOutput::writeString, StreamOutput::writeInt);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.totalFrames);
        if (this.error != null) {
            out.writeBoolean(true);
            out.writeException((Throwable)this.error);
        } else {
            out.writeBoolean(false);
        }
    }

    public RestStatus status() {
        return this.error != null ? ExceptionsHelper.status((Throwable)ExceptionsHelper.unwrapCause((Throwable)this.error)) : RestStatus.OK;
    }

    public Map<String, StackTrace> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public Map<String, String> getExecutables() {
        return this.executables;
    }

    public Map<String, Integer> getStackTraceEvents() {
        return this.stackTraceEvents;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }

    public Exception getError() {
        return this.error;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.stackTraces != null) {
            builder.startObject("stack_traces");
            builder.mapContents(this.stackTraces);
            builder.endObject();
        }
        if (this.stackFrames != null) {
            builder.startObject("stack_frames");
            builder.mapContents(this.stackFrames);
            builder.endObject();
        }
        if (this.executables != null) {
            builder.startObject("executables");
            builder.mapContents(this.executables);
            builder.endObject();
        }
        if (this.stackTraceEvents != null) {
            builder.startObject("stack_trace_events");
            builder.mapContents(this.stackTraceEvents);
            builder.endObject();
        }
        builder.field("total_frames", this.totalFrames);
        if (this.error != null) {
            builder.startObject("error");
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.error);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        GetProfilingResponse response = (GetProfilingResponse)((Object)o);
        return this.totalFrames == response.totalFrames && Objects.equals(this.stackTraces, response.stackTraces) && Objects.equals(this.stackFrames, response.stackFrames) && Objects.equals(this.executables, response.executables) && Objects.equals(this.stackTraceEvents, response.stackTraceEvents) && Objects.equals(this.error, response.error);
    }

    public int hashCode() {
        return Objects.hash(this.stackTraces, this.stackFrames, this.executables, this.stackTraceEvents, this.totalFrames, this.error);
    }
}

