/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks.security.android;

import javax.xml.xpath.XPathExpression;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.Xml;
import org.sonar.plugins.xml.checks.security.android.AbstractAndroidManifestCheck;
import org.sonarsource.analyzer.commons.xml.XPathBuilder;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SimpleXPathBasedCheck;
import org.w3c.dom.Node;

@Rule(key="S4507")
public class DebugFeatureCheck
extends SimpleXPathBasedCheck {
    private static final String MESSAGE = "Make sure this debug feature is deactivated before delivering the code in production.";
    private final XPathExpression debuggableXPath = XPathBuilder.forExpression("/manifest/application/@n1:debuggable[.='true']").withNamespace("n1", "http://schemas.android.com/apk/res/android").build();
    private final XPathExpression customErrorsXPath = XPathBuilder.forExpression("/configuration/system.web/customErrors/@mode").build();

    @Override
    public final void scanFile(XmlFile file) {
        if (AbstractAndroidManifestCheck.isAndroidManifestFile(file)) {
            this.evaluateAsList(this.debuggableXPath, file.getDocument()).forEach(node -> this.reportIssue((Node)node, MESSAGE));
        }
        if (Xml.isDotNetApplicationConfig(file.getInputFile())) {
            this.evaluateAsList(this.customErrorsXPath, file.getDocument()).stream().filter(modeAttribute -> "off".equalsIgnoreCase(modeAttribute.getNodeValue())).forEach(node -> this.reportIssue((Node)node, MESSAGE));
        }
    }
}

