/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.core.Streams;
import org.elasticsearch.core.Strings;

public class BlobCacheUtils {
    public static int toIntBytes(long l) {
        return ByteSizeUnit.BYTES.toIntBytes(l);
    }

    public static void throwEOF(long channelPos, long len, Object file) throws EOFException {
        throw new EOFException(Strings.format((String)"unexpected EOF reading [%d-%d] from %s", (Object[])new Object[]{channelPos, channelPos + len, file}));
    }

    public static void ensureSeek(long pos, IndexInput input) throws IOException {
        long length = input.length();
        if (pos > length) {
            throw new EOFException("Reading past end of file [position=" + pos + ", length=" + input.length() + "] for " + input);
        }
        if (pos < 0L) {
            throw new IOException("Seeking to negative position [" + pos + "] for " + input);
        }
    }

    public static ByteRange computeRange(long rangeSize, long position, long length) {
        long start = position / rangeSize * rangeSize;
        long end = Math.min(start + rangeSize, length);
        return ByteRange.of(start, end);
    }

    public static void ensureSlice(String sliceName, long sliceOffset, long sliceLength, IndexInput input) {
        if (sliceOffset < 0L || sliceLength < 0L || sliceOffset + sliceLength > input.length()) {
            throw new IllegalArgumentException("slice() " + sliceName + " out of bounds: offset=" + sliceOffset + ",length=" + sliceLength + ",fileLength=" + input.length() + ": " + input);
        }
    }

    public static int readSafe(InputStream inputStream, ByteBuffer copyBuffer, long rangeStart, long remaining, Object cacheFileReference) throws IOException {
        int len = remaining < (long)copyBuffer.remaining() ? BlobCacheUtils.toIntBytes(remaining) : copyBuffer.remaining();
        int bytesRead = Streams.read((InputStream)inputStream, (ByteBuffer)copyBuffer, (int)len);
        if (bytesRead <= 0) {
            BlobCacheUtils.throwEOF(rangeStart, remaining, cacheFileReference);
        }
        return bytesRead;
    }
}

