/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.blobcache.store;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.store.ImmutableDirectoryException;

public class InMemoryNoOpCommitDirectory
extends FilterDirectory {
    private final Directory realDirectory;
    private final Set<String> deletedFiles = new CopyOnWriteArraySet<String>();

    public InMemoryNoOpCommitDirectory(Directory realDirectory) {
        super((Directory)new ByteBuffersDirectory((LockFactory)NoLockFactory.INSTANCE));
        this.realDirectory = realDirectory;
    }

    public Directory getRealDirectory() {
        return this.realDirectory;
    }

    public String[] listAll() throws IOException {
        String[] ephemeralFiles = this.in.listAll();
        String[] realFiles = (String[])Arrays.stream(this.realDirectory.listAll()).filter(f -> !this.deletedFiles.contains(f)).toArray(String[]::new);
        String[] allFiles = new String[ephemeralFiles.length + realFiles.length];
        System.arraycopy(ephemeralFiles, 0, allFiles, 0, ephemeralFiles.length);
        System.arraycopy(realFiles, 0, allFiles, ephemeralFiles.length, realFiles.length);
        return allFiles;
    }

    public void deleteFile(String name) throws IOException {
        InMemoryNoOpCommitDirectory.ensureMutable(name);
        try {
            this.in.deleteFile(name);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
        this.deletedFiles.add(name);
    }

    public long fileLength(String name) throws IOException {
        try {
            return this.in.fileLength(name);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.realDirectory.fileLength(name);
        }
    }

    public void sync(Collection<String> names) {
    }

    public void syncMetaData() {
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        InMemoryNoOpCommitDirectory.ensureMutable(name);
        assert (this.notOverwritingRealSegmentsFile(name)) : name;
        this.deletedFiles.remove(name);
        return super.createOutput(name, context);
    }

    public void rename(String source, String dest) throws IOException {
        InMemoryNoOpCommitDirectory.ensureMutable(source);
        InMemoryNoOpCommitDirectory.ensureMutable(dest);
        assert (this.notOverwritingRealSegmentsFile(dest)) : dest;
        super.rename(source, dest);
        this.deletedFiles.remove(dest);
    }

    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) {
        throw new UnsupportedOperationException();
    }

    public void copyFrom(Directory from, String src, String dest, IOContext context) {
        throw new UnsupportedOperationException();
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        try {
            return this.in.openInput(name, context);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return this.realDirectory.openInput(name, context);
        }
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.in, this.realDirectory});
    }

    public Set<String> getPendingDeletions() throws IOException {
        return super.getPendingDeletions();
    }

    private static void ensureMutable(String name) {
        if (!(name.startsWith("segments_") || name.startsWith("pending_segments_") || name.matches("^recovery\\..*\\.segments_.*$"))) {
            throw new ImmutableDirectoryException("file [" + name + "] is not mutable");
        }
    }

    private boolean notOverwritingRealSegmentsFile(String name) throws IOException {
        return !name.startsWith("segments_") || Arrays.stream(this.realDirectory.listAll()).noneMatch(s -> s.equals(name));
    }

    public String toString() {
        return "InMemoryNoOpCommitDirectory(real=" + this.realDirectory + ", delegate=" + this.in + "}";
    }
}

