/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import java.net.InetSocketAddress;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4TcpChannel
implements TcpChannel {
    private final Channel channel;
    private final boolean isServer;
    private final String profile;
    private final ListenableFuture<Void> connectContext;
    private final ListenableFuture<Void> closeContext = new ListenableFuture();
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();
    private final boolean rstOnClose;

    Netty4TcpChannel(Channel channel, boolean isServer, String profile, boolean rstOnClose, ChannelFuture connectFuture) {
        this.channel = channel;
        this.isServer = isServer;
        this.profile = profile;
        this.connectContext = new ListenableFuture();
        this.rstOnClose = rstOnClose;
        Netty4TcpChannel.addListener(this.channel.closeFuture(), this.closeContext);
        Netty4TcpChannel.addListener(connectFuture, this.connectContext);
    }

    public static void addListener(ChannelFuture channelFuture, ListenableFuture<Void> listener) {
        channelFuture.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                if (cause instanceof Error) {
                    ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        });
    }

    public static ChannelPromise addPromise(ActionListener<Void> listener, Channel channel) {
        ChannelPromise writePromise = channel.newPromise();
        writePromise.addListener(f -> {
            if (f.isSuccess()) {
                listener.onResponse(null);
            } else {
                Throwable cause = f.cause();
                ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
                if (cause instanceof Error) {
                    listener.onFailure(new Exception(cause));
                } else {
                    listener.onFailure((Exception)cause);
                }
            }
        });
        return writePromise;
    }

    public void close() {
        if (this.rstOnClose) {
            this.rstAndClose();
        } else {
            this.channel.close();
        }
    }

    private void rstAndClose() {
        Releasable[] releasableArray = new Releasable[2];
        releasableArray[0] = () -> {
            block4: {
                if (this.channel.isOpen()) {
                    try {
                        this.channel.config().setOption(ChannelOption.SO_LINGER, (Object)0);
                    }
                    catch (Exception e) {
                        if (IOUtils.MAC_OS_X) {
                            return;
                        }
                        if (!this.channel.isOpen()) break block4;
                        throw e;
                    }
                }
            }
        };
        releasableArray[1] = () -> ((Channel)this.channel).close();
        Releasables.close((Releasable[])releasableArray);
    }

    public boolean isServerChannel() {
        return this.isServer;
    }

    public String getProfile() {
        return this.profile;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.addListener(listener);
    }

    public void addConnectListener(ActionListener<Void> listener) {
        this.connectContext.addListener(listener);
    }

    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.channel.writeAndFlush((Object)Netty4Utils.toByteBuf(reference), Netty4TcpChannel.addPromise(listener, this.channel));
        if (this.channel.eventLoop().isShutdown()) {
            listener.onFailure((Exception)new TransportException("Cannot send message, event loop is shutting down."));
        }
    }

    public Channel getNettyChannel() {
        return this.channel;
    }

    public String toString() {
        return "Netty4TcpChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.channel.remoteAddress() + ", profile=" + this.profile + "}";
    }
}

