/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.go.externalreport;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.go.externalreport.ExternalIssue;
import org.sonarsource.slang.plugin.AbstractPropertyHandlerSensor;
import org.sonarsource.slang.utils.LogArg;

public abstract class AbstractReportSensor
extends AbstractPropertyHandlerSensor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractReportSensor.class);
    static final long DEFAULT_REMEDIATION_COST = 5L;
    static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    static final String GENERIC_ISSUE_KEY = "issue";

    protected AbstractReportSensor(AnalysisWarnings analysisWarnings, String propertyKey, String propertyName, String configurationkey) {
        super(analysisWarnings, propertyKey, propertyName, configurationkey, "go");
    }

    @Nullable
    abstract ExternalIssue parse(String var1);

    @Override
    public Consumer<File> reportConsumer(SensorContext context) {
        return file -> this.importReport(context, (File)file);
    }

    protected String logPrefix() {
        return this.getClass().getSimpleName() + ": ";
    }

    private void importReport(SensorContext context, File report) {
        try {
            for (String line : Files.readAllLines(report.toPath(), StandardCharsets.UTF_8)) {
                ExternalIssue issue;
                if (line.isEmpty() || (issue = this.parse(line)) == null) continue;
                this.addLineIssue(context, issue);
            }
        }
        catch (IOException e) {
            LOG.error("{}No issues information will be saved as the report file '{}' can't be read.", new Object[]{LogArg.lazyArg(this::logPrefix), report.getPath(), e});
        }
    }

    static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    @CheckForNull
    InputFile getInputFile(SensorContext context, String filePath) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.or(predicates.hasRelativePath(filePath), predicates.hasAbsolutePath(filePath)));
        if (inputFile == null) {
            LOG.warn("{}No input file found for {}. No {} issues will be imported on this file.", new Object[]{LogArg.lazyArg(this::logPrefix), filePath, this.propertyName()});
        }
        return inputFile;
    }

    void addLineIssue(SensorContext context, ExternalIssue issue) {
        InputFile inputFile = this.getInputFile(context, issue.filename);
        if (inputFile != null) {
            NewExternalIssue newExternalIssue = context.newExternalIssue();
            NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(issue.message).on((InputComponent)inputFile).at(inputFile.selectLine(issue.lineNumber));
            newExternalIssue.at(primaryLocation).ruleId(issue.ruleKey).engineId(issue.linter).type(issue.type).severity(DEFAULT_SEVERITY).remediationEffortMinutes(Long.valueOf(5L)).save();
        }
    }

    public static void createExternalRuleRepository(RulesDefinition.Context context, String linterId, String linterName) {
        RulesDefinition.NewRepository externalRepo = context.createExternalRepository(linterId, "go").setName(linterName);
        String pathToRulesMeta = "org/sonar/l10n/go/rules/" + linterId + "/rules.json";
        try (InputStreamReader inputStreamReader = new InputStreamReader(AbstractReportSensor.class.getClassLoader().getResourceAsStream(pathToRulesMeta), StandardCharsets.UTF_8);){
            JsonArray jsonArray = Json.parse(inputStreamReader).asArray();
            for (JsonValue jsonValue : jsonArray) {
                JsonObject rule = jsonValue.asObject();
                RulesDefinition.NewRule newRule = externalRepo.createRule(rule.getString("key", null)).setName(rule.getString("name", null)).setHtmlDescription(rule.getString("description", null));
                newRule.setDebtRemediationFunction(newRule.debtRemediationFunctions().constantPerIssue("5min"));
                if (!linterId.equals("govet")) continue;
                newRule.setType(RuleType.BUG);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + pathToRulesMeta, e);
        }
        externalRepo.done();
    }
}

