/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geoip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Command;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.core.PathUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xcontent.XContentGenerator;
import org.elasticsearch.xcontent.XContentType;

public class GeoIpCli
extends Command {
    private static final byte[] EMPTY_BUF = new byte[512];
    private final OptionSpec<String> sourceDirectory;
    private final OptionSpec<String> targetDirectory;

    public GeoIpCli() {
        super("A CLI tool to prepare local GeoIp database service");
        this.sourceDirectory = this.parser.acceptsAll(Arrays.asList("s", "source"), "Source directory").withRequiredArg().required();
        this.targetDirectory = this.parser.acceptsAll(Arrays.asList("t", "target"), "Target directory").withRequiredArg();
    }

    protected void execute(Terminal terminal, OptionSet options, ProcessInfo processInfo) throws Exception {
        Path source = this.getPath((String)options.valueOf(this.sourceDirectory));
        String targetString = (String)options.valueOf(this.targetDirectory);
        Path target = targetString != null ? this.getPath(targetString) : source;
        this.copyTgzToTarget(source, target);
        this.packDatabasesToTgz(terminal, source, target);
        this.createOverviewJson(terminal, target);
    }

    @SuppressForbidden(reason="file arg for cli")
    private Path getPath(String file) {
        return PathUtils.get((String)file, (String[])new String[0]);
    }

    private void copyTgzToTarget(Path source, Path target) throws IOException {
        if (source.equals(target)) {
            return;
        }
        try (Stream<Path> files = Files.list(source);){
            for (Path path : files.filter(p -> p.getFileName().toString().endsWith(".tgz")).collect(Collectors.toList())) {
                Files.copy(path, target.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    private void packDatabasesToTgz(Terminal terminal, Path source, Path target) throws IOException {
        try (Stream<Path> files = Files.list(source);){
            for (Path path : files.filter(p -> p.getFileName().toString().endsWith(".mmdb")).collect(Collectors.toList())) {
                String fileName = path.getFileName().toString();
                Path compressedPath = target.resolve(fileName.replaceAll("mmdb$", "") + "tgz");
                terminal.println((CharSequence)("Found " + fileName + ", will compress it to " + compressedPath.getFileName()));
                OutputStream fos = Files.newOutputStream(compressedPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try (GZIPOutputStream gos = new GZIPOutputStream(new BufferedOutputStream(fos));){
                    long size = Files.size(path);
                    ((OutputStream)gos).write(this.createTarHeader(fileName, size));
                    Files.copy(path, gos);
                    if (size % 512L != 0L) {
                        ((OutputStream)gos).write(EMPTY_BUF, 0, (int)(512L - size % 512L));
                    }
                    ((OutputStream)gos).write(EMPTY_BUF);
                    ((OutputStream)gos).write(EMPTY_BUF);
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
        }
    }

    private void createOverviewJson(Terminal terminal, Path directory) throws IOException {
        Path overview = directory.resolve("overview.json");
        try (Stream<Path> files = Files.list(directory);
             BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(overview, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
             XContentGenerator generator = XContentType.JSON.xContent().createGenerator((OutputStream)os);){
            generator.writeStartArray();
            for (Path db : files.filter(p -> p.getFileName().toString().endsWith(".tgz")).collect(Collectors.toList())) {
                terminal.println((CharSequence)("Adding " + db.getFileName() + " to overview.json"));
                MessageDigest md5 = MessageDigests.md5();
                try (DigestInputStream dis = new DigestInputStream(new BufferedInputStream(Files.newInputStream(db, new OpenOption[0])), md5);){
                    dis.transferTo(OutputStream.nullOutputStream());
                }
                String digest = MessageDigests.toHexString((byte[])md5.digest());
                generator.writeStartObject();
                String fileName = db.getFileName().toString();
                generator.writeStringField("name", fileName);
                generator.writeStringField("md5_hash", digest);
                generator.writeStringField("url", fileName);
                generator.writeNumberField("updated", System.currentTimeMillis());
                generator.writeEndObject();
            }
            generator.writeEndArray();
        }
        terminal.println((CharSequence)"overview.json created");
    }

    private byte[] createTarHeader(String name, long size) {
        byte[] buf = new byte[512];
        byte[] sizeBytes = String.format(Locale.ROOT, "%1$012o", size).getBytes(StandardCharsets.UTF_8);
        byte[] nameBytes = name.substring(Math.max(0, name.length() - 100)).getBytes(StandardCharsets.US_ASCII);
        byte[] id = "0001750".getBytes(StandardCharsets.UTF_8);
        byte[] permission = "000644 ".getBytes(StandardCharsets.UTF_8);
        byte[] time = String.format(Locale.ROOT, "%1$012o", System.currentTimeMillis() / 1000L).getBytes(StandardCharsets.UTF_8);
        System.arraycopy(nameBytes, 0, buf, 0, nameBytes.length);
        System.arraycopy(permission, 0, buf, 100, 7);
        System.arraycopy(id, 0, buf, 108, 7);
        System.arraycopy(id, 0, buf, 116, 7);
        System.arraycopy(sizeBytes, 0, buf, 124, 12);
        System.arraycopy(time, 0, buf, 136, 12);
        int checksum = 256;
        for (byte b : buf) {
            checksum += b & 0xFF;
        }
        byte[] checksumBytes = String.format(Locale.ROOT, "%1$07o", checksum).getBytes(StandardCharsets.UTF_8);
        System.arraycopy(checksumBytes, 0, buf, 148, 7);
        return buf;
    }
}

