/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference;
import kotlin.jvm.internal.RepeatableContainer;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.KVisibility;
import kotlin.reflect.jvm.internal.KCallableImpl;
import kotlin.reflect.jvm.internal.KFunctionImpl;
import kotlin.reflect.jvm.internal.KPropertyImpl;
import kotlin.reflect.jvm.internal.KTypeImpl;
import kotlin.reflect.jvm.internal.ModuleByClassLoaderKt;
import kotlin.reflect.jvm.internal.Util;
import kotlin.reflect.jvm.internal.calls.AnnotationConstructorCallerKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectAnnotationSource;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectKotlinClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeModuleData;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.RuntimeSourceElementFactory;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.constants.AnnotationValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ArrayValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.EnumValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ErrorValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.KClassValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.NullValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedArrayValue;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.MemberDeserializer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00ca\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001al\u0010\u0011\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014\"\b\b\u0001\u0010\u0012*\u00020\u00062\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u0002H\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u001d\u0010\u001e\u001a\u0019\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u0002H\u00120\u001f\u00a2\u0006\u0002\b!H\u0000\u00a2\u0006\u0002\u0010\"\u001a.\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*H\u0002\u001a(\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00162\u0006\u0010$\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010)\u001a\u00020*H\u0002\u001a%\u0010-\u001a\u0002H.\"\u0004\b\u0000\u0010.2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u001a\u0016\u00102\u001a\u0004\u0018\u00010\u000e*\u0002032\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0014\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u000105*\u0004\u0018\u00010\u000eH\u0000\u001a\u0010\u00106\u001a\u0004\u0018\u000107*\u0004\u0018\u00010\u000eH\u0000\u001a\u0014\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000109*\u0004\u0018\u00010\u000eH\u0000\u001a\u0012\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;*\u00020=H\u0000\u001a\u0014\u0010>\u001a\u0006\u0012\u0002\b\u00030\u0016*\u0006\u0012\u0002\b\u00030\u0016H\u0000\u001a\u000e\u0010?\u001a\u0004\u0018\u00010<*\u00020@H\u0002\u001a\u0012\u0010A\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016*\u00020BH\u0000\u001a\u000e\u0010C\u001a\u0004\u0018\u00010D*\u00020EH\u0000\u001a\u001a\u0010F\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030G2\u0006\u0010$\u001a\u00020%H\u0002\u001a\u0018\u0010H\u001a\b\u0012\u0004\u0012\u00020<0;*\b\u0012\u0004\u0012\u00020<0;H\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\n*\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006I"}, d2={"JVM_STATIC", "Lkotlin/reflect/jvm/internal/impl/name/FqName;", "getJVM_STATIC", "()Lorg/jetbrains/kotlin/name/FqName;", "instanceReceiverParameter", "Lkotlin/reflect/jvm/internal/impl/descriptors/ReceiverParameterDescriptor;", "Lkotlin/reflect/jvm/internal/impl/descriptors/CallableDescriptor;", "getInstanceReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "isInlineClassType", "", "Lkotlin/reflect/KType;", "(Lkotlin/reflect/KType;)Z", "defaultPrimitiveValue", "", "type", "Ljava/lang/reflect/Type;", "deserializeToDescriptor", "D", "M", "Lkotlin/reflect/jvm/internal/impl/protobuf/MessageLite;", "moduleAnchor", "Ljava/lang/Class;", "proto", "nameResolver", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/NameResolver;", "typeTable", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/TypeTable;", "metadataVersion", "Lkotlin/reflect/jvm/internal/impl/metadata/deserialization/BinaryVersion;", "createDescriptor", "Lkotlin/Function2;", "Lkotlin/reflect/jvm/internal/impl/serialization/deserialization/MemberDeserializer;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/protobuf/MessageLite;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/TypeTable;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "loadClass", "classLoader", "Ljava/lang/ClassLoader;", "packageName", "", "className", "arrayDimensions", "", "kotlinClassId", "Lkotlin/reflect/jvm/internal/impl/name/ClassId;", "reflectionCall", "R", "block", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "arrayToRuntimeValue", "Lkotlin/reflect/jvm/internal/impl/resolve/constants/ArrayValue;", "asKCallableImpl", "Lkotlin/reflect/jvm/internal/KCallableImpl;", "asKFunctionImpl", "Lkotlin/reflect/jvm/internal/KFunctionImpl;", "asKPropertyImpl", "Lkotlin/reflect/jvm/internal/KPropertyImpl;", "computeAnnotations", "", "", "Lkotlin/reflect/jvm/internal/impl/descriptors/annotations/Annotated;", "createArrayType", "toAnnotationInstance", "Lkotlin/reflect/jvm/internal/impl/descriptors/annotations/AnnotationDescriptor;", "toJavaClass", "Lkotlin/reflect/jvm/internal/impl/descriptors/ClassDescriptor;", "toKVisibility", "Lkotlin/reflect/KVisibility;", "Lkotlin/reflect/jvm/internal/impl/descriptors/DescriptorVisibility;", "toRuntimeValue", "Lkotlin/reflect/jvm/internal/impl/resolve/constants/ConstantValue;", "unwrapRepeatableAnnotations", "kotlin-reflection"})
public final class UtilKt {
    @NotNull
    private static final FqName JVM_STATIC = new FqName("kotlin.jvm.JvmStatic");

    @NotNull
    public static final FqName getJVM_STATIC() {
        return JVM_STATIC;
    }

    @Nullable
    public static final Class<?> toJavaClass(@NotNull ClassDescriptor $this$toJavaClass) {
        AnnotatedElement annotatedElement;
        Intrinsics.checkNotNullParameter($this$toJavaClass, "<this>");
        SourceElement sourceElement = $this$toJavaClass.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "source");
        SourceElement source = sourceElement;
        if (source instanceof KotlinJvmBinarySourceElement) {
            annotatedElement = ((ReflectKotlinClass)((KotlinJvmBinarySourceElement)source).getBinaryClass()).getKlass();
        } else if (source instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
            annotatedElement = ((ReflectJavaClass)((RuntimeSourceElementFactory.RuntimeSourceElement)source).getJavaElement()).getElement();
        } else {
            ClassId classId = DescriptorUtilsKt.getClassId($this$toJavaClass);
            if (classId == null) {
                return null;
            }
            ClassId classId2 = classId;
            annotatedElement = UtilKt.loadClass(ReflectClassUtilKt.getSafeClassLoader($this$toJavaClass.getClass()), classId2, 0);
        }
        return annotatedElement;
    }

    private static final Class<?> loadClass(ClassLoader classLoader, ClassId kotlinClassId, int arrayDimensions) {
        FqNameUnsafe fqNameUnsafe = kotlinClassId.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "kotlinClassId.asSingleFqName().toUnsafe()");
        Object object = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        ClassId javaClassId = object == null ? kotlinClassId : object;
        object = javaClassId.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "javaClassId.packageFqName.asString()");
        Object object2 = object;
        object = javaClassId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue(object, "javaClassId.relativeClassName.asString()");
        return UtilKt.loadClass(classLoader, (String)object2, (String)object, arrayDimensions);
    }

    static /* synthetic */ Class loadClass$default(ClassLoader classLoader, ClassId classId, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return UtilKt.loadClass(classLoader, classId, n);
    }

    private static final Class<?> loadClass(ClassLoader classLoader, String packageName, String className, int arrayDimensions) {
        block32: {
            if (!Intrinsics.areEqual(packageName, "kotlin")) break block32;
            switch (className) {
                case "Array": {
                    return Object[].class;
                }
                case "BooleanArray": {
                    return boolean[].class;
                }
                case "ByteArray": {
                    return byte[].class;
                }
                case "CharArray": {
                    return char[].class;
                }
                case "DoubleArray": {
                    return double[].class;
                }
                case "FloatArray": {
                    return float[].class;
                }
                case "IntArray": {
                    return int[].class;
                }
                case "LongArray": {
                    return long[].class;
                }
                case "ShortArray": {
                    return short[].class;
                }
            }
        }
        String fqName2 = packageName + '.' + StringsKt.replace$default(className, '.', '$', false, 4, null);
        if (arrayDimensions > 0) {
            fqName2 = StringsKt.repeat("[", arrayDimensions) + 'L' + fqName2 + ';';
        }
        return ReflectJavaClassFinderKt.tryLoadClass(classLoader, fqName2);
    }

    @NotNull
    public static final Class<?> createArrayType(@NotNull Class<?> $this$createArrayType) {
        Intrinsics.checkNotNullParameter($this$createArrayType, "<this>");
        return Array.newInstance($this$createArrayType, 0).getClass();
    }

    @Nullable
    public static final KVisibility toKVisibility(@NotNull DescriptorVisibility $this$toKVisibility) {
        Intrinsics.checkNotNullParameter($this$toKVisibility, "<this>");
        DescriptorVisibility descriptorVisibility = $this$toKVisibility;
        return Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PUBLIC) ? KVisibility.PUBLIC : (Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PROTECTED) ? KVisibility.PROTECTED : (Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.INTERNAL) ? KVisibility.INTERNAL : ((Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PRIVATE) ? true : Intrinsics.areEqual(descriptorVisibility, DescriptorVisibilities.PRIVATE_TO_THIS)) ? KVisibility.PRIVATE : null)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Annotation> computeAnnotations(@NotNull Annotated $this$computeAnnotations) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$computeAnnotations, "<this>");
        Iterable $this$mapNotNull$iv = $this$computeAnnotations.getAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation2;
            Annotation annotation3;
            Annotation annotation4;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            AnnotationDescriptor it = (AnnotationDescriptor)element$iv$iv;
            boolean bl2 = false;
            SourceElement source = it.getSource();
            if (source instanceof ReflectAnnotationSource) {
                annotation4 = ((ReflectAnnotationSource)source).getAnnotation();
            } else if (source instanceof RuntimeSourceElementFactory.RuntimeSourceElement) {
                ReflectJavaAnnotation reflectJavaAnnotation;
                ReflectJavaElement reflectJavaElement = ((RuntimeSourceElementFactory.RuntimeSourceElement)source).getJavaElement();
                ReflectJavaAnnotation reflectJavaAnnotation2 = reflectJavaAnnotation = reflectJavaElement instanceof ReflectJavaAnnotation ? (ReflectJavaAnnotation)reflectJavaElement : null;
                annotation4 = reflectJavaAnnotation == null ? null : reflectJavaAnnotation.getAnnotation();
            } else {
                annotation4 = UtilKt.toAnnotationInstance(it);
            }
            if ((annotation3 = annotation4) == null) continue;
            Annotation it$iv$iv = annotation2 = annotation3;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return UtilKt.unwrapRepeatableAnnotations((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Annotation> unwrapRepeatableAnnotations(List<? extends Annotation> $this$unwrapRepeatableAnnotations) {
        List list2;
        boolean bl;
        block9: {
            Iterable $this$any$iv = $this$unwrapRepeatableAnnotations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Annotation it = (Annotation)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(it)).getSimpleName(), "Container")) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = $this$unwrapRepeatableAnnotations;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                List<Annotation> list3;
                Annotation it = (Annotation)element$iv$iv;
                boolean bl3 = false;
                Class<KClass<Annotation>> klass = JvmClassMappingKt.getJavaClass(JvmClassMappingKt.getAnnotationClass(it));
                if (Intrinsics.areEqual(klass.getSimpleName(), "Container") && klass.getAnnotation(RepeatableContainer.class) != null) {
                    Object object = klass.getDeclaredMethod("value", new Class[0]).invoke((Object)it, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<out kotlin.Annotation>");
                    }
                    list3 = ArraysKt.asList((Annotation[])object);
                } else {
                    list3 = CollectionsKt.listOf(it);
                }
                Iterable list$iv$iv = list3;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = $this$unwrapRepeatableAnnotations;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Annotation toAnnotationInstance(AnnotationDescriptor $this$toAnnotationInstance) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object;
        ClassDescriptor classDescriptor2 = DescriptorUtilsKt.getAnnotationClass($this$toAnnotationInstance);
        Class<?> clazz = classDescriptor2 == null ? null : UtilKt.toJavaClass(classDescriptor2);
        Object object2 = object = clazz instanceof Class ? clazz : null;
        if (object == null) {
            return null;
        }
        Class<?> annotationClass = object;
        object = $this$toAnnotationInstance.getAllValueArguments().entrySet();
        Class<?> clazz2 = annotationClass;
        boolean $i$f$mapNotNull = false;
        classDescriptor2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<String, Object> pair;
            Pair<String, Object> pair2;
            Pair<String, Object> pair3;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry $dstr$name$value = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Name name = (Name)$dstr$name$value.getKey();
            ConstantValue value2 = (ConstantValue)$dstr$name$value.getValue();
            Object object3 = annotationClass.getClassLoader();
            Intrinsics.checkNotNullExpressionValue(object3, "annotationClass.classLoader");
            Object object4 = UtilKt.toRuntimeValue(value2, (ClassLoader)object3);
            if (object4 == null) {
                pair3 = null;
            } else {
                object3 = object4;
                String string2 = name.asString();
                Object p0 = object3;
                boolean bl3 = false;
                pair3 = TuplesKt.to(string2, p0);
            }
            if ((pair2 = pair3) == null) continue;
            Pair<String, Object> it$iv$iv = pair = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        return (Annotation)AnnotationConstructorCallerKt.createAnnotationInstance$default(clazz2, MapsKt.toMap(list2), null, 4, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object toRuntimeValue(ConstantValue<?> $this$toRuntimeValue, ClassLoader classLoader) {
        Object object;
        ConstantValue<?> constantValue = $this$toRuntimeValue;
        if (constantValue instanceof AnnotationValue) {
            object = UtilKt.toAnnotationInstance((AnnotationDescriptor)((AnnotationValue)$this$toRuntimeValue).getValue());
            return object;
        } else if (constantValue instanceof ArrayValue) {
            object = UtilKt.arrayToRuntimeValue((ArrayValue)$this$toRuntimeValue, classLoader);
            return object;
        } else if (constantValue instanceof EnumValue) {
            Class clazz;
            Pair pair = (Pair)((EnumValue)$this$toRuntimeValue).getValue();
            ClassId enumClassId = (ClassId)pair.component1();
            Name entryName = (Name)pair.component2();
            Class clazz2 = UtilKt.loadClass$default(classLoader, enumClassId, 0, 4, null);
            if (clazz2 == null) {
                return null;
            }
            Class enumClass2 = clazz = clazz2;
            boolean bl = false;
            object = Util.getEnumConstantByName(enumClass2, entryName.asString());
            return object;
        } else if (constantValue instanceof KClassValue) {
            KClassValue.Value classValue = (KClassValue.Value)((KClassValue)$this$toRuntimeValue).getValue();
            if (classValue instanceof KClassValue.Value.NormalClass) {
                object = UtilKt.loadClass(classLoader, ((KClassValue.Value.NormalClass)classValue).getClassId(), ((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                return object;
            } else {
                if (!(classValue instanceof KClassValue.Value.LocalClass)) throw new NoWhenBranchMatchedException();
                ClassifierDescriptor classifierDescriptor = ((KClassValue.Value.LocalClass)classValue).getType().getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) return null;
                ClassDescriptor classDescriptor2 = (ClassDescriptor)classifierDescriptor;
                ClassDescriptor classDescriptor3 = classDescriptor2;
                if (classDescriptor3 == null) {
                    return null;
                }
                object = UtilKt.toJavaClass(classDescriptor3);
            }
            return object;
        } else {
            if (constantValue instanceof ErrorValue) {
                return null;
            }
            boolean bl = constantValue instanceof NullValue;
            if (bl) {
                return null;
            }
            object = $this$toRuntimeValue.getValue();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object arrayToRuntimeValue(ArrayValue $this$arrayToRuntimeValue, ClassLoader classLoader) {
        Object object;
        Object object2;
        void $this$mapTo$iv$iv2;
        DeserializedArrayValue deserializedArrayValue;
        DeserializedArrayValue deserializedArrayValue2 = deserializedArrayValue = $this$arrayToRuntimeValue instanceof DeserializedArrayValue ? (DeserializedArrayValue)$this$arrayToRuntimeValue : null;
        if (deserializedArrayValue == null) {
            return null;
        }
        KotlinType type2 = deserializedArrayValue.getType();
        Iterable $this$map$iv = (Iterable)$this$arrayToRuntimeValue.getValue();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            object2 = (ConstantValue)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            Object object3 = UtilKt.toRuntimeValue(it, classLoader);
            collection.add(object3);
        }
        List values = (List)destination$iv$iv2;
        PrimitiveType primitiveType = KotlinBuiltIns.getPrimitiveArrayElementType(type2);
        int n = primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[primitiveType.ordinal()];
        switch (n) {
            case 1: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                boolean[] $i$f$mapTo22 = new boolean[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n2;
                    if ((object4 = values.get(n2 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
                    }
                    $i$f$mapTo22[n2] = (Boolean)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case 2: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                char[] $i$f$mapTo22 = new char[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n3;
                    if ((object4 = values.get(n3 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Char");
                    }
                    $i$f$mapTo22[n3] = ((Character)object4).charValue();
                }
                object = $i$f$mapTo22;
                break;
            }
            case 3: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                byte[] $i$f$mapTo22 = new byte[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n4;
                    if ((object4 = values.get(n4 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Byte");
                    }
                    $i$f$mapTo22[n4] = (Byte)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case 4: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                short[] $i$f$mapTo22 = new short[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n5;
                    if ((object4 = values.get(n5 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Short");
                    }
                    $i$f$mapTo22[n5] = (Short)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case 5: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                int[] $i$f$mapTo22 = new int[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n6;
                    if ((object4 = values.get(n6 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    $i$f$mapTo22[n6] = (Integer)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case 6: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                float[] $i$f$mapTo22 = new float[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n7;
                    if ((object4 = values.get(n7 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                    }
                    $i$f$mapTo22[n7] = ((Float)object4).floatValue();
                }
                object = $i$f$mapTo22;
                break;
            }
            case 7: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                long[] $i$f$mapTo22 = new long[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n8;
                    if ((object4 = values.get(n8 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Long");
                    }
                    $i$f$mapTo22[n8] = (Long)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case 8: {
                Object object4;
                int $this$mapTo$iv$iv2 = 0;
                int destination$iv$iv2 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                double[] $i$f$mapTo22 = new double[destination$iv$iv2];
                while ($this$mapTo$iv$iv2 < destination$iv$iv2) {
                    int n9;
                    if ((object4 = values.get(n9 = $this$mapTo$iv$iv2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                    }
                    $i$f$mapTo22[n9] = (Double)object4;
                }
                object = $i$f$mapTo22;
                break;
            }
            case -1: {
                Class clazz;
                ClassDescriptor $i$f$mapTo22;
                Object object4;
                boolean $this$mapTo$iv$iv2 = KotlinBuiltIns.isArray(type2);
                if (!$this$mapTo$iv$iv2) {
                    boolean $i$a$-check-UtilKt$arrayToRuntimeValue$102 = false;
                    String $i$a$-check-UtilKt$arrayToRuntimeValue$102 = Intrinsics.stringPlus("Not an array type: ", type2);
                    throw new IllegalStateException($i$a$-check-UtilKt$arrayToRuntimeValue$102.toString());
                }
                KotlinType $i$a$-check-UtilKt$arrayToRuntimeValue$102 = CollectionsKt.single(type2.getArguments()).getType();
                Intrinsics.checkNotNullExpressionValue($i$a$-check-UtilKt$arrayToRuntimeValue$102, "type.arguments.single().type");
                KotlinType argType = $i$a$-check-UtilKt$arrayToRuntimeValue$102;
                Object object5 = argType.getConstructor().getDeclarationDescriptor();
                ClassDescriptor classDescriptor2 = $i$f$mapTo22 = object5 instanceof ClassDescriptor ? (ClassDescriptor)object5 : null;
                if ($i$f$mapTo22 == null) {
                    throw new IllegalStateException(Intrinsics.stringPlus("Not a class type: ", argType).toString());
                }
                ClassDescriptor classifier2 = $i$f$mapTo22;
                if (KotlinBuiltIns.isString(argType)) {
                    int $i$f$mapTo22 = 0;
                    int n10 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                    object4 = new String[n10];
                    while ($i$f$mapTo22 < n10) {
                        int n11;
                        Object bl;
                        if ((bl = values.get(n11 = $i$f$mapTo22++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        object4[n11] = (String)bl;
                    }
                    object = object4;
                    break;
                }
                if (KotlinBuiltIns.isKClass(classifier2)) {
                    int $i$f$mapTo22 = 0;
                    int n12 = ((List)$this$arrayToRuntimeValue.getValue()).size();
                    object4 = new Class[n12];
                    while ($i$f$mapTo22 < n12) {
                        int n13;
                        Object bl;
                        if ((bl = values.get(n13 = $i$f$mapTo22++)) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<*>");
                        }
                        object4[n13] = (Class)bl;
                    }
                    object = object4;
                    break;
                }
                object4 = DescriptorUtilsKt.getClassId(classifier2);
                if (object4 == null) {
                    clazz = null;
                } else {
                    Object it = object2 = object4;
                    boolean bl = false;
                    clazz = UtilKt.loadClass$default(classLoader, (ClassId)it, 0, 4, null);
                }
                object5 = clazz;
                if (object5 == null) {
                    return null;
                }
                Object argClass = object5;
                object4 = Array.newInstance(argClass, ((List)$this$arrayToRuntimeValue.getValue()).size());
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<in kotlin.Any?>");
                }
                Object[] array = (Object[])object4;
                int n14 = values.size();
                int n15 = 0;
                while (n15 < n14) {
                    int n16;
                    int it = n16 = n15++;
                    boolean bl = false;
                    array[it] = values.get(it);
                }
                object = array;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    @Nullable
    public static final KFunctionImpl asKFunctionImpl(@Nullable Object $this$asKFunctionImpl) {
        KFunctionImpl kFunctionImpl;
        KFunctionImpl kFunctionImpl2;
        KFunctionImpl kFunctionImpl3 = kFunctionImpl2 = $this$asKFunctionImpl instanceof KFunctionImpl ? (KFunctionImpl)$this$asKFunctionImpl : null;
        if (kFunctionImpl2 == null) {
            KCallable kCallable;
            FunctionReference functionReference = $this$asKFunctionImpl instanceof FunctionReference ? (FunctionReference)$this$asKFunctionImpl : null;
            KCallable kCallable2 = kCallable = functionReference == null ? null : functionReference.compute();
            kFunctionImpl = kCallable instanceof KFunctionImpl ? (KFunctionImpl)kCallable : null;
        } else {
            kFunctionImpl = kFunctionImpl2;
        }
        return kFunctionImpl;
    }

    @Nullable
    public static final KPropertyImpl<?> asKPropertyImpl(@Nullable Object $this$asKPropertyImpl) {
        KPropertyImpl kPropertyImpl;
        KPropertyImpl kPropertyImpl2;
        KPropertyImpl kPropertyImpl3 = kPropertyImpl2 = $this$asKPropertyImpl instanceof KPropertyImpl ? (KPropertyImpl)$this$asKPropertyImpl : null;
        if (kPropertyImpl2 == null) {
            KCallable kCallable;
            PropertyReference propertyReference = $this$asKPropertyImpl instanceof PropertyReference ? (PropertyReference)$this$asKPropertyImpl : null;
            KCallable kCallable2 = kCallable = propertyReference == null ? null : propertyReference.compute();
            kPropertyImpl = kCallable instanceof KPropertyImpl ? (KPropertyImpl)kCallable : null;
        } else {
            kPropertyImpl = kPropertyImpl2;
        }
        return kPropertyImpl;
    }

    @Nullable
    public static final KCallableImpl<?> asKCallableImpl(@Nullable Object $this$asKCallableImpl) {
        KCallableImpl kCallableImpl;
        KCallableImpl kCallableImpl2;
        KCallableImpl kCallableImpl3 = kCallableImpl2 = $this$asKCallableImpl instanceof KCallableImpl ? (KCallableImpl)$this$asKCallableImpl : null;
        return kCallableImpl2 == null ? ((kCallableImpl = (KCallableImpl)UtilKt.asKFunctionImpl($this$asKCallableImpl)) == null ? (KCallableImpl)UtilKt.asKPropertyImpl($this$asKCallableImpl) : kCallableImpl) : kCallableImpl2;
    }

    @Nullable
    public static final ReceiverParameterDescriptor getInstanceReceiverParameter(@NotNull CallableDescriptor $this$instanceReceiverParameter) {
        Intrinsics.checkNotNullParameter($this$instanceReceiverParameter, "<this>");
        return $this$instanceReceiverParameter.getDispatchReceiverParameter() != null ? ((ClassDescriptor)$this$instanceReceiverParameter.getContainingDeclaration()).getThisAsReceiverParameter() : null;
    }

    @NotNull
    public static final <M extends MessageLite, D extends CallableDescriptor> D deserializeToDescriptor(@NotNull Class<?> moduleAnchor, @NotNull M proto, @NotNull NameResolver nameResolver2, @NotNull TypeTable typeTable, @NotNull BinaryVersion metadataVersion, @NotNull Function2<? super MemberDeserializer, ? super M, ? extends D> createDescriptor) {
        List<ProtoBuf.TypeParameter> list2;
        Intrinsics.checkNotNullParameter(moduleAnchor, "moduleAnchor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        Intrinsics.checkNotNullParameter(typeTable, "typeTable");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(createDescriptor, "createDescriptor");
        RuntimeModuleData moduleData2 = ModuleByClassLoaderKt.getOrCreateModule(moduleAnchor);
        M m = proto;
        if (m instanceof ProtoBuf.Function) {
            list2 = ((ProtoBuf.Function)proto).getTypeParameterList();
        } else if (m instanceof ProtoBuf.Property) {
            list2 = ((ProtoBuf.Property)proto).getTypeParameterList();
        } else {
            throw new IllegalStateException(Intrinsics.stringPlus("Unsupported message: ", proto).toString());
        }
        List<ProtoBuf.TypeParameter> typeParameters2 = list2;
        DeserializationComponents deserializationComponents = moduleData2.getDeserialization();
        DeclarationDescriptor declarationDescriptor = moduleData2.getModule();
        VersionRequirementTable versionRequirementTable = VersionRequirementTable.Companion.getEMPTY();
        Intrinsics.checkNotNullExpressionValue(typeParameters2, "typeParameters");
        DeserializationContext context = new DeserializationContext(deserializationComponents, nameResolver2, declarationDescriptor, typeTable, versionRequirementTable, metadataVersion, null, null, typeParameters2);
        return (D)((CallableDescriptor)createDescriptor.invoke(new MemberDeserializer(context), proto));
    }

    public static final boolean isInlineClassType(@NotNull KType $this$isInlineClassType) {
        KotlinType kotlinType;
        KTypeImpl kTypeImpl;
        Intrinsics.checkNotNullParameter($this$isInlineClassType, "<this>");
        KTypeImpl kTypeImpl2 = kTypeImpl = $this$isInlineClassType instanceof KTypeImpl ? (KTypeImpl)$this$isInlineClassType : null;
        return kTypeImpl == null ? false : InlineClassesUtilsKt.isInlineClassType(kotlinType = kTypeImpl.getType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Object defaultPrimitiveValue(@NotNull Type type2) {
        Comparable<Boolean> comparable;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof Class)) return null;
        if (!((Class)type2).isPrimitive()) return null;
        Type type3 = type2;
        if (Intrinsics.areEqual(type3, Boolean.TYPE)) {
            comparable = false;
            return comparable;
        } else if (Intrinsics.areEqual(type3, Character.TYPE)) {
            comparable = Character.valueOf('\u0000');
            return comparable;
        } else if (Intrinsics.areEqual(type3, Byte.TYPE)) {
            comparable = (byte)0;
            return comparable;
        } else if (Intrinsics.areEqual(type3, Short.TYPE)) {
            comparable = (short)0;
            return comparable;
        } else if (Intrinsics.areEqual(type3, Integer.TYPE)) {
            comparable = 0;
            return comparable;
        } else if (Intrinsics.areEqual(type3, Float.TYPE)) {
            comparable = Float.valueOf(0.0f);
            return comparable;
        } else if (Intrinsics.areEqual(type3, Long.TYPE)) {
            comparable = 0L;
            return comparable;
        } else if (Intrinsics.areEqual(type3, Double.TYPE)) {
            comparable = 0.0;
            return comparable;
        } else {
            if (!Intrinsics.areEqual(type3, Void.TYPE)) throw new UnsupportedOperationException(Intrinsics.stringPlus("Unknown primitive: ", type2));
            throw new IllegalStateException("Parameter with void type is illegal");
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

