/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.Cast;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.event.AbstractBroadcastDispatch;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.service.AnnotatedServiceLifecycleHandler;
import org.gradle.internal.service.scopes.EventScope;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.StatefulListener;

public class DefaultListenerManager
implements ListenerManager,
AnnotatedServiceLifecycleHandler {
    private final Map<Object, ListenerDetails> allListeners = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Object, ListenerDetails> allLoggers = new LinkedHashMap<Object, ListenerDetails>();
    private final Map<Class<?>, EventBroadcast<?>> broadcasters = new ConcurrentHashMap();
    private final List<AnnotatedServiceLifecycleHandler.Registration> pendingRegistrations = new ArrayList<AnnotatedServiceLifecycleHandler.Registration>();
    private final Object lock = new Object();
    private final Class<? extends Scope> scope;
    private final DefaultListenerManager parent;

    public DefaultListenerManager(Class<? extends Scope> scope2) {
        this(scope2, null);
    }

    private DefaultListenerManager(Class<? extends Scope> scope2, DefaultListenerManager parent2) {
        this.scope = scope2;
        this.parent = parent2;
    }

    @Override
    public Class<? extends Annotation> getAnnotation() {
        return StatefulListener.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void whenRegistered(AnnotatedServiceLifecycleHandler.Registration registration) {
        Object object = this.lock;
        synchronized (object) {
            this.pendingRegistrations.add(registration);
            for (EventBroadcast<?> broadcast : this.broadcasters.values()) {
                broadcast.checkRegistration(registration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddPendingRegistrations(Class<?> type2) {
        Object object = this.lock;
        synchronized (object) {
            int i = 0;
            while (i < this.pendingRegistrations.size()) {
                AnnotatedServiceLifecycleHandler.Registration registration = this.pendingRegistrations.get(i);
                if (type2.isAssignableFrom(registration.getDeclaredType())) {
                    this.addListener(registration.getInstance());
                    this.pendingRegistrations.remove(i);
                    continue;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allListeners.containsKey(listener)) {
                details = new ListenerDetails(listener);
                this.allListeners.put(listener, details);
            }
        }
        if (details != null) {
            details.useAsListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        ListenerDetails details;
        Object object = this.lock;
        synchronized (object) {
            details = this.allListeners.remove(listener);
            if (details != null) {
                details.disconnect();
            }
        }
        if (details != null) {
            details.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object logger) {
        ListenerDetails details = null;
        Object object = this.lock;
        synchronized (object) {
            if (!this.allLoggers.containsKey(logger)) {
                details = new ListenerDetails(logger);
                this.allLoggers.put(logger, details);
            }
        }
        if (details != null) {
            details.useAsLogger();
        }
    }

    @Override
    public <T> boolean hasListeners(Class<T> listenerClass) {
        EventBroadcast<T> broadcaster = this.getBroadcasterInternal(listenerClass);
        return !((EventBroadcast)broadcaster).listeners.isEmpty();
    }

    @Override
    public <T> T getBroadcaster(Class<T> listenerClass) {
        this.assertCanBroadcast(listenerClass);
        return this.getBroadcasterInternal(listenerClass).getBroadcaster();
    }

    @Override
    public <T> AnonymousListenerBroadcast<T> createAnonymousBroadcaster(Class<T> listenerClass) {
        this.assertCanBroadcast(listenerClass);
        AnonymousListenerBroadcast<T> broadcast = new AnonymousListenerBroadcast<T>(listenerClass);
        broadcast.add(this.getBroadcasterInternal(listenerClass).getDispatch(true));
        return broadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> EventBroadcast<T> getBroadcasterInternal(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            EventBroadcast<T> broadcaster = (EventBroadcast<T>)Cast.uncheckedCast(this.broadcasters.get(listenerClass));
            if (broadcaster == null) {
                broadcaster = new EventBroadcast<T>(listenerClass);
                this.broadcasters.put(listenerClass, broadcaster);
                for (ListenerDetails listener : this.allListeners.values()) {
                    broadcaster.maybeAdd(listener);
                }
                for (ListenerDetails logger : this.allLoggers.values()) {
                    broadcaster.maybeSetLogger(logger);
                }
            }
            return broadcaster;
        }
    }

    private <T> void assertCanBroadcast(Class<T> listenerClass) {
        EventScope scope2 = listenerClass.getAnnotation(EventScope.class);
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Listener type %s is not annotated with @EventScope.", listenerClass.getName()));
        }
        if (!scope2.value().equals(this.scope)) {
            throw new IllegalArgumentException(String.format("Listener type %s with scope %s cannot be used to generate events in scope %s.", listenerClass.getName(), scope2.value().getSimpleName(), this.scope.getSimpleName()));
        }
    }

    public DefaultListenerManager createChild(Class<? extends Scope> scope2) {
        return new DefaultListenerManager(scope2, this);
    }

    private class ListenerDetails
    implements Dispatch<MethodInvocation> {
        final Object listener;
        final Dispatch<MethodInvocation> dispatch;
        final AtomicBoolean removed = new AtomicBoolean();
        final ReentrantLock notifyingLock = new ReentrantLock();

        public ListenerDetails(Object listener) {
            this.listener = listener;
            this.dispatch = new ReflectionDispatch(listener);
        }

        void disconnect() {
            this.removed.set(true);
        }

        @Override
        public void dispatch(MethodInvocation message2) {
            if (!this.removed.get()) {
                this.dispatch.dispatch(message2);
            }
        }

        void startNotification() {
            this.notifyingLock.lock();
        }

        void endNotification() {
            this.notifyingLock.unlock();
        }

        void remove() {
            this.notifyingLock.lock();
            try {
                for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                    broadcaster.maybeRemove(this);
                }
            }
            finally {
                this.notifyingLock.unlock();
            }
        }

        void useAsLogger() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeSetLogger(this);
            }
        }

        void useAsListener() {
            for (EventBroadcast broadcaster : DefaultListenerManager.this.broadcasters.values()) {
                broadcaster.maybeAdd(this);
            }
        }
    }

    private class EventBroadcast<T>
    implements Dispatch<MethodInvocation> {
        private final Class<T> type;
        private final ListenerDispatch dispatch;
        private final ListenerDispatch dispatchNoLogger;
        private final boolean stateful;
        private volatile ProxyDispatchAdapter<T> source;
        private final Set<ListenerDetails> listeners = new LinkedHashSet<ListenerDetails>();
        private final List<Runnable> queuedOperations = new LinkedList<Runnable>();
        private final ReentrantLock broadcasterLock = new ReentrantLock();
        private ListenerDetails logger;
        private Dispatch<MethodInvocation> parentDispatch;
        private List<Dispatch<MethodInvocation>> allWithLogger = Collections.emptyList();
        private List<Dispatch<MethodInvocation>> allWithNoLogger = Collections.emptyList();
        private boolean notified;

        EventBroadcast(Class<T> type2) {
            this.type = type2;
            this.stateful = type2.getAnnotation(StatefulListener.class) != null;
            this.dispatch = new ListenerDispatch(type2, true);
            this.dispatchNoLogger = new ListenerDispatch(type2, false);
            if (DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(type2).getDispatch(true);
                this.invalidateDispatchCache();
            }
        }

        @Override
        public void dispatch(MethodInvocation message2) {
            this.dispatch.dispatch(message2);
        }

        Dispatch<MethodInvocation> getDispatch(boolean includeLogger) {
            return includeLogger ? this.dispatch : this.dispatchNoLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getBroadcaster() {
            if (this.source == null) {
                EventBroadcast eventBroadcast = this;
                synchronized (eventBroadcast) {
                    if (this.source == null) {
                        this.source = new ProxyDispatchAdapter<T>(this, this.type, new Class[0]);
                    }
                }
            }
            return this.source.getSource();
        }

        private void invalidateDispatchCache() {
            this.ensureAllWithLoggerInitialized();
            this.ensureAllWithoutLoggerInitialized();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeAdd(final ListenerDetails listener) {
            if (this.type.isInstance(listener.listener)) {
                if (this.broadcasterLock.tryLock()) {
                    try {
                        this.checkListenersCanBeAdded();
                        this.listeners.add(listener);
                        this.invalidateDispatchCache();
                    }
                    finally {
                        this.broadcasterLock.unlock();
                    }
                }
                List<Runnable> list2 = this.queuedOperations;
                synchronized (list2) {
                    this.queuedOperations.add(new Runnable(){

                        @Override
                        public void run() {
                            EventBroadcast.this.listeners.add(listener);
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void maybeRemove(final ListenerDetails listener) {
            if (this.broadcasterLock.tryLock()) {
                try {
                    if (!this.listeners.remove(listener)) return;
                    this.invalidateDispatchCache();
                    return;
                }
                finally {
                    this.broadcasterLock.unlock();
                }
            }
            List<Runnable> list2 = this.queuedOperations;
            synchronized (list2) {
                this.queuedOperations.add(new Runnable(){

                    @Override
                    public void run() {
                        EventBroadcast.this.listeners.remove(listener);
                    }
                });
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeSetLogger(final ListenerDetails candidate2) {
            if (this.type.isInstance(candidate2.listener)) {
                if (this.broadcasterLock.tryLock()) {
                    try {
                        this.doSetLogger(candidate2);
                        this.invalidateDispatchCache();
                    }
                    finally {
                        this.broadcasterLock.unlock();
                    }
                }
                List<Runnable> list2 = this.queuedOperations;
                synchronized (list2) {
                    this.queuedOperations.add(new Runnable(){

                        @Override
                        public void run() {
                            EventBroadcast.this.doSetLogger(candidate2);
                        }
                    });
                }
            }
        }

        public void checkRegistration(AnnotatedServiceLifecycleHandler.Registration registration) {
            if (this.type.isAssignableFrom(registration.getDeclaredType())) {
                this.broadcasterLock.lock();
                try {
                    this.checkListenersCanBeAdded();
                }
                finally {
                    this.broadcasterLock.unlock();
                }
            }
        }

        private void checkListenersCanBeAdded() {
            if (this.stateful && this.notified) {
                throw new IllegalStateException(String.format("Cannot add listener of type %s after events have been broadcast.", this.type.getSimpleName()));
            }
        }

        private void doSetLogger(ListenerDetails candidate2) {
            if (this.logger == null && DefaultListenerManager.this.parent != null) {
                this.parentDispatch = DefaultListenerManager.this.parent.getBroadcasterInternal(this.type).getDispatch(false);
            }
            this.logger = candidate2;
        }

        private List<Dispatch<MethodInvocation>> startNotification(boolean includeLogger) {
            this.takeOwnership();
            if (!this.notified) {
                DefaultListenerManager.this.maybeAddPendingRegistrations(this.type);
                this.notified = true;
            }
            List<Dispatch<MethodInvocation>> result2 = includeLogger ? this.allWithLogger : this.allWithNoLogger;
            this.doStartNotification(result2);
            return result2;
        }

        private void doStartNotification(List<Dispatch<MethodInvocation>> result2) {
            for (Dispatch<MethodInvocation> dispatch : result2) {
                if (!(dispatch instanceof ListenerDetails)) continue;
                ListenerDetails listenerDetails = (ListenerDetails)dispatch;
                listenerDetails.startNotification();
            }
        }

        private void ensureAllWithoutLoggerInitialized() {
            if (this.parentDispatch == null && this.listeners.isEmpty()) {
                this.allWithNoLogger = Collections.emptyList();
            } else {
                ArrayList<Dispatch<MethodInvocation>> dispatchers = new ArrayList<Dispatch<MethodInvocation>>();
                if (this.parentDispatch != null) {
                    dispatchers.add(this.parentDispatch);
                }
                dispatchers.addAll(this.listeners);
                this.allWithNoLogger = dispatchers;
            }
        }

        private void ensureAllWithLoggerInitialized() {
            this.allWithLogger = this.logger == null && this.parentDispatch == null && this.listeners.isEmpty() ? Collections.emptyList() : this.buildAllWithLogger();
        }

        private void takeOwnership() {
            if (this.broadcasterLock.isHeldByCurrentThread()) {
                throw new IllegalStateException(String.format("Cannot notify listeners of type %s as these listeners are already being notified.", this.type.getSimpleName()));
            }
            this.broadcasterLock.lock();
        }

        private List<Dispatch<MethodInvocation>> buildAllWithLogger() {
            ArrayList<Dispatch<MethodInvocation>> result2 = new ArrayList<Dispatch<MethodInvocation>>();
            if (this.logger != null) {
                result2.add(this.logger);
            }
            if (this.parentDispatch != null) {
                result2.add(this.parentDispatch);
            }
            result2.addAll(this.listeners);
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void endNotification(List<Dispatch<MethodInvocation>> dispatchers) {
            for (Dispatch<MethodInvocation> dispatcher : dispatchers) {
                if (!(dispatcher instanceof ListenerDetails)) continue;
                ListenerDetails listener = (ListenerDetails)dispatcher;
                listener.endNotification();
            }
            try {
                List<Runnable> list2 = this.queuedOperations;
                synchronized (list2) {
                    if (!this.queuedOperations.isEmpty()) {
                        for (Runnable queuedOperation : this.queuedOperations) {
                            queuedOperation.run();
                        }
                        this.invalidateDispatchCache();
                    }
                }
            }
            finally {
                this.broadcasterLock.unlock();
            }
        }

        private class ListenerDispatch
        extends AbstractBroadcastDispatch<T> {
            private final boolean includeLogger;

            ListenerDispatch(Class<T> type2, boolean includeLogger) {
                super(type2);
                this.includeLogger = includeLogger;
            }

            @Override
            public void dispatch(MethodInvocation invocation) {
                List dispatchers = EventBroadcast.this.startNotification(this.includeLogger);
                try {
                    if (!dispatchers.isEmpty()) {
                        this.dispatch(invocation, dispatchers.iterator());
                    }
                }
                finally {
                    EventBroadcast.this.endNotification(dispatchers);
                }
            }
        }
    }
}

