/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.google.common.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.gradle.internal.impldep.com.google.common.annotations.GwtCompatible;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.util.concurrent.AsyncFunction;
import org.gradle.internal.impldep.com.google.common.util.concurrent.FluentFuture;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Futures;
import org.gradle.internal.impldep.com.google.common.util.concurrent.ListenableFuture;
import org.gradle.internal.impldep.com.google.common.util.concurrent.MoreExecutors;
import org.gradle.internal.impldep.com.google.errorprone.annotations.ForOverride;
import org.gradle.internal.impldep.org.checkerframework.checker.nullness.qual.Nullable;

@GwtCompatible
abstract class AbstractTransformFuture<I, O, F, T>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    @Nullable ListenableFuture<? extends I> inputFuture;
    @Nullable F function;

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function2, Executor executor) {
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> output = new AsyncTransformFuture<I, O>(input, function2);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    static <I, O> ListenableFuture<O> create(ListenableFuture<I> input, Function<? super I, ? extends O> function2, Executor executor) {
        Preconditions.checkNotNull(function2);
        TransformFuture<? super I, ? extends O> output = new TransformFuture<I, O>(input, function2);
        input.addListener(output, MoreExecutors.rejectionPropagatingExecutor(executor, output));
        return output;
    }

    AbstractTransformFuture(ListenableFuture<? extends I> inputFuture, F function2) {
        this.inputFuture = Preconditions.checkNotNull(inputFuture);
        this.function = Preconditions.checkNotNull(function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T transformResult;
        I sourceResult;
        ListenableFuture<I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        if (this.isCancelled() | localInputFuture == null | localFunction == null) {
            return;
        }
        this.inputFuture = null;
        if (localInputFuture.isCancelled()) {
            boolean unused = this.setFuture(localInputFuture);
            return;
        }
        try {
            sourceResult = Futures.getDone(localInputFuture);
        }
        catch (CancellationException e) {
            this.cancel(false);
            return;
        }
        catch (ExecutionException e) {
            this.setException(e.getCause());
            return;
        }
        catch (RuntimeException e) {
            this.setException(e);
            return;
        }
        catch (Error e) {
            this.setException(e);
            return;
        }
        try {
            transformResult = this.doTransform(localFunction, sourceResult);
        }
        catch (Throwable t) {
            this.setException(t);
            return;
        }
        finally {
            this.function = null;
        }
        this.setResult(transformResult);
    }

    @ForOverride
    abstract @Nullable T doTransform(F var1, @Nullable I var2) throws Exception;

    @ForOverride
    abstract void setResult(@Nullable T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    @Override
    protected String pendingToString() {
        String string2;
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        String superString = super.pendingToString();
        String resultString = "";
        if (localInputFuture != null) {
            string2 = String.valueOf(localInputFuture);
            resultString = new StringBuilder(16 + String.valueOf(string2).length()).append("inputFuture=[").append(string2).append("], ").toString();
        }
        if (localFunction != null) {
            string2 = resultString;
            String string3 = String.valueOf(localFunction);
            return new StringBuilder(11 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("function=[").append(string3).append("]").toString();
        }
        if (superString != null) {
            String string4 = String.valueOf(resultString);
            String string5 = String.valueOf(superString);
            return string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        return null;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        TransformFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function2) {
            super(inputFuture, function2);
        }

        @Override
        @Nullable O doTransform(Function<? super I, ? extends O> function2, @Nullable I input) {
            return function2.apply(input);
        }

        @Override
        void setResult(@Nullable O result2) {
            this.set(result2);
        }
    }

    private static final class AsyncTransformFuture<I, O>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        AsyncTransformFuture(ListenableFuture<? extends I> inputFuture, AsyncFunction<? super I, ? extends O> function2) {
            super(inputFuture, function2);
        }

        @Override
        ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> function2, @Nullable I input) throws Exception {
            ListenableFuture<? extends O> outputFuture = function2.apply(input);
            Preconditions.checkNotNull(outputFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", function2);
            return outputFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends O> result2) {
            this.setFuture(result2);
        }
    }
}

