/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Constructor;
import org.gradle.internal.UncheckedException;

public class JavaReflectionUtil {
    public static Class<?> getWrapperTypeForPrimitiveType(Class<?> type2) {
        if (type2 == Character.TYPE) {
            return Character.class;
        }
        if (type2 == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type2 == Long.TYPE) {
            return Long.class;
        }
        if (type2 == Integer.TYPE) {
            return Integer.class;
        }
        if (type2 == Short.TYPE) {
            return Short.class;
        }
        if (type2 == Byte.TYPE) {
            return Byte.class;
        }
        if (type2 == Float.TYPE) {
            return Float.class;
        }
        if (type2 == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException(String.format("Don't know the wrapper type for primitive type %s.", type2));
    }

    public static <T> T newInstance(Class<T> c) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

