/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.gradle.internal.service.DefaultServiceMethodFactory;
import org.gradle.internal.service.RelevantMethodsBuilder;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceMethodFactory;

public class RelevantMethods {
    private static final ConcurrentMap<Class<?>, RelevantMethods> METHODS_CACHE = new ConcurrentHashMap();
    private static final ServiceMethodFactory SERVICE_METHOD_FACTORY = new DefaultServiceMethodFactory();
    final List<ServiceMethod> decorators;
    final List<ServiceMethod> factories;
    final List<ServiceMethod> configurers;

    RelevantMethods(List<Method> decorators, List<Method> factories, List<Method> configurers) {
        this.decorators = RelevantMethods.toServiceMethodList(decorators);
        this.factories = RelevantMethods.toServiceMethodList(factories);
        this.configurers = RelevantMethods.toServiceMethodList(configurers);
    }

    private static List<ServiceMethod> toServiceMethodList(List<Method> methods2) {
        ArrayList<ServiceMethod> result2 = new ArrayList<ServiceMethod>(methods2.size());
        for (Method method : methods2) {
            result2.add(SERVICE_METHOD_FACTORY.toServiceMethod(method));
        }
        return result2;
    }

    public static RelevantMethods getMethods(Class<?> type2) {
        RelevantMethods relevantMethods = (RelevantMethods)METHODS_CACHE.get(type2);
        if (relevantMethods == null) {
            relevantMethods = RelevantMethods.buildRelevantMethods(type2);
            METHODS_CACHE.putIfAbsent(type2, relevantMethods);
        }
        return relevantMethods;
    }

    private static RelevantMethods buildRelevantMethods(Class<?> type2) {
        RelevantMethodsBuilder builder = new RelevantMethodsBuilder(type2);
        RelevantMethods.addDecoratorMethods(builder);
        RelevantMethods.addFactoryMethods(builder);
        RelevantMethods.addConfigureMethods(builder);
        RelevantMethods relevantMethods = builder.build();
        return relevantMethods;
    }

    private static void addConfigureMethods(RelevantMethodsBuilder builder) {
        Class<?> type2 = builder.type;
        Iterator<Method> iterator2 = builder.remainingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            if (!method.getName().equals("configure")) continue;
            if (!method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must return void.", type2.getSimpleName(), method.getName()));
            }
            builder.add(iterator2, builder.configurers, method);
        }
    }

    private static void addFactoryMethods(RelevantMethodsBuilder builder) {
        Class<?> type2 = builder.type;
        Iterator<Method> iterator2 = builder.remainingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            if (!method.getName().startsWith("create") || Modifier.isStatic(method.getModifiers())) continue;
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type2.getSimpleName(), method.getName()));
            }
            builder.add(iterator2, builder.factories, method);
        }
    }

    private static void addDecoratorMethods(RelevantMethodsBuilder builder) {
        Class<?> type2 = builder.type;
        Iterator<Method> iterator2 = builder.remainingMethods.iterator();
        while (iterator2.hasNext()) {
            Method method = iterator2.next();
            if (!method.getName().startsWith("create") && !method.getName().startsWith("decorate")) continue;
            if (method.getReturnType().equals(Void.TYPE)) {
                throw new ServiceLookupException(String.format("Method %s.%s() must not return void.", type2.getSimpleName(), method.getName()));
            }
            if (!RelevantMethods.takesReturnTypeAsParameter(method)) continue;
            builder.add(iterator2, builder.decorators, method);
        }
    }

    private static boolean takesReturnTypeAsParameter(Method method) {
        for (Class<?> param : method.getParameterTypes()) {
            if (!param.equals(method.getReturnType())) continue;
            return true;
        }
        return false;
    }
}

