/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.Transformers;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.javax.annotation.Nullable;

public abstract class CollectionUtils {
    @Nullable
    public static <T> T findSingle(Iterable<T> source) {
        return Iterables.isEmpty(source) ? null : (T)CollectionUtils.single(source);
    }

    public static <T> T single(Iterable<? extends T> source) {
        Iterator<T> iterator2 = source.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException("Expecting collection with single element, got none.");
        }
        T element = iterator2.next();
        if (iterator2.hasNext()) {
            throw new IllegalArgumentException("Expecting collection with single element, got multiple.");
        }
        return element;
    }

    public static <T> Collection<? extends T> checkedCast(Class<T> type2, Collection<?> input) {
        for (Object o : input) {
            Cast.castNullable(type2, o);
        }
        return (Collection)Cast.uncheckedNonnullCast(input);
    }

    @Nullable
    public static <T> T findFirst(Iterable<? extends T> source, Spec<? super T> filter2) {
        for (T item : source) {
            if (!filter2.isSatisfiedBy(item)) continue;
            return item;
        }
        return null;
    }

    @Nullable
    public static <T> T findFirst(T[] source, Spec<? super T> filter2) {
        for (T thing : source) {
            if (!filter2.isSatisfiedBy(thing)) continue;
            return thing;
        }
        return null;
    }

    public static <T> T first(Iterable<? extends T> source) {
        return source.iterator().next();
    }

    public static <T> boolean any(Iterable<? extends T> source, Spec<? super T> filter2) {
        return CollectionUtils.findFirst(source, filter2) != null;
    }

    public static <T> boolean any(T[] source, Spec<? super T> filter2) {
        return CollectionUtils.findFirst(source, filter2) != null;
    }

    public static <T> Set<T> filter(Set<? extends T> set, Spec<? super T> filter2) {
        return CollectionUtils.filter(set, new LinkedHashSet(), filter2);
    }

    public static <T> List<T> filter(List<? extends T> list2, Spec<? super T> filter2) {
        return CollectionUtils.filter(list2, Lists.newArrayListWithCapacity(list2.size()), filter2);
    }

    public static <T> List<T> filter(T[] array, Spec<? super T> filter2) {
        return CollectionUtils.filter(Arrays.asList(array), Lists.newArrayListWithCapacity(array.length), filter2);
    }

    public static <T> List<T> sort(Iterable<? extends T> things, Comparator<? super T> comparator) {
        List<? extends T> copy2 = CollectionUtils.toMutableList(things);
        Collections.sort(copy2, comparator);
        return copy2;
    }

    public static <T extends Comparable<T>> List<T> sort(Iterable<T> things) {
        List<T> copy2 = CollectionUtils.toMutableList(things);
        Collections.sort(copy2);
        return copy2;
    }

    public static <T, C extends Collection<T>> C filter(Iterable<? extends T> source, C destination, Spec<? super T> filter2) {
        for (T item : source) {
            if (!filter2.isSatisfiedBy(item)) continue;
            destination.add(item);
        }
        return destination;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Spec<Map.Entry<K, V>> filter2) {
        return CollectionUtils.filter(map, new HashMap(), filter2);
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Map<K, V> destination, Spec<Map.Entry<K, V>> filter2) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (!filter2.isSatisfiedBy(entry)) continue;
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    public static <R, I> R[] collectArray(I[] list2, Class<R> newType, Transformer<? extends R, ? super I> transformer) {
        Object[] destination = (Object[])Array.newInstance(newType, list2.length);
        return CollectionUtils.collectArray(list2, destination, transformer);
    }

    public static <R, I> R[] collectArray(I[] list2, R[] destination, Transformer<? extends R, ? super I> transformer) {
        assert (list2.length <= destination.length);
        for (int i = 0; i < list2.length; ++i) {
            destination[i] = transformer.transform(list2[i]);
        }
        return destination;
    }

    public static <R, I> List<R> collect(I[] list2, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(Arrays.asList(list2), transformer);
    }

    public static <R, I> Set<R> collect(Set<? extends I> set, Transformer<? extends R, ? super I> transformer) {
        return CollectionUtils.collect(set, new HashSet(set.size()), transformer);
    }

    public static <R, I> List<R> collect(Iterable<? extends I> source, Transformer<? extends R, ? super I> transformer) {
        if (source instanceof Collection) {
            Collection collection = (Collection)Cast.uncheckedNonnullCast(source);
            return CollectionUtils.collect(source, new ArrayList(collection.size()), transformer);
        }
        return CollectionUtils.collect(source, new LinkedList(), transformer);
    }

    public static <R, I, C extends Collection<R>> C collect(Iterable<? extends I> source, C destination, Transformer<? extends R, ? super I> transformer) {
        for (I item : source) {
            destination.add(transformer.transform(item));
        }
        return destination;
    }

    public static List<String> toStringList(Iterable<?> iterable) {
        return CollectionUtils.collect(iterable, new LinkedList(), Transformers.asString());
    }

    public static List<?> flattenCollections(Object ... things) {
        return CollectionUtils.flattenCollections(Object.class, things);
    }

    public static <T> List<T> flattenCollections(Class<T> type2, Object ... things) {
        if (things == null) {
            return Collections.singletonList(null);
        }
        if (things.length == 0) {
            return Collections.emptyList();
        }
        if (things.length == 1) {
            Object thing = things[0];
            if (thing == null) {
                return Collections.singletonList(null);
            }
            if (thing.getClass().isArray()) {
                Object[] thingArray = (Object[])thing;
                ArrayList<T> list2 = new ArrayList<T>(thingArray.length);
                for (Object thingThing : thingArray) {
                    list2.addAll(CollectionUtils.flattenCollections(type2, thingThing));
                }
                return list2;
            }
            if (thing instanceof Collection) {
                Collection collection = (Collection)thing;
                ArrayList<T> list3 = new ArrayList<T>();
                for (Object element : collection) {
                    list3.addAll(CollectionUtils.flattenCollections(type2, element));
                }
                return list3;
            }
            return Collections.singletonList(Cast.cast(type2, thing));
        }
        ArrayList<T> list4 = new ArrayList<T>();
        for (Object thing : things) {
            list4.addAll(CollectionUtils.flattenCollections(type2, thing));
        }
        return list4;
    }

    public static <T> List<T> toList(Iterable<? extends T> things) {
        if (things instanceof List) {
            List castThings = (List)things;
            return castThings;
        }
        return CollectionUtils.toMutableList(things);
    }

    public static <T> List<T> toList(Enumeration<? extends T> things) {
        ArrayList<T> list2 = new ArrayList<T>();
        while (things.hasMoreElements()) {
            ((AbstractList)list2).add(things.nextElement());
        }
        return list2;
    }

    private static <T> List<T> toMutableList(Iterable<? extends T> things) {
        if (things == null) {
            return new ArrayList(0);
        }
        ArrayList<T> list2 = new ArrayList<T>();
        for (T thing : things) {
            list2.add(thing);
        }
        return list2;
    }

    public static <T> List<T> intersection(Collection<? extends Collection<T>> availableValuesByDescriptor) {
        ArrayList<T> result2 = new ArrayList<T>();
        Iterator<Collection<T>> iterator2 = availableValuesByDescriptor.iterator();
        if (iterator2.hasNext()) {
            Collection<T> firstSet = iterator2.next();
            result2.addAll(firstSet);
            while (iterator2.hasNext()) {
                Collection<T> next = iterator2.next();
                result2.retainAll(next);
            }
        }
        return result2;
    }

    public static <T> List<T> toList(T[] things) {
        if (things == null || things.length == 0) {
            return new ArrayList(0);
        }
        ArrayList list2 = new ArrayList(things.length);
        Collections.addAll(list2, things);
        return list2;
    }

    public static <T> Set<T> toSet(Iterable<? extends T> things) {
        if (things == null) {
            return new HashSet(0);
        }
        if (things instanceof Set) {
            Set castThings = (Set)things;
            return castThings;
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T thing : things) {
            set.add(thing);
        }
        return set;
    }

    public static <E> List<E> compact(List<E> list2) {
        boolean foundAtLeastOneNull = false;
        List<E> compacted = null;
        int i = 0;
        for (E element : list2) {
            if (element == null) {
                if (!foundAtLeastOneNull) {
                    compacted = new ArrayList(list2.size());
                    if (i > 0) {
                        compacted.addAll(list2.subList(0, i));
                    }
                }
                foundAtLeastOneNull = true;
            } else if (foundAtLeastOneNull) {
                compacted.add(element);
            }
            ++i;
        }
        return foundAtLeastOneNull ? compacted : list2;
    }

    public static <C extends Collection<String>> C stringize(Iterable<?> source, C destination) {
        return CollectionUtils.collect(source, destination, Transformers.asString());
    }

    public static List<String> stringize(Collection<?> source) {
        return CollectionUtils.stringize(source, new ArrayList(source.size()));
    }

    public static <E> boolean replace(List<E> list2, Spec<? super E> filter2, Transformer<? extends E, ? super E> transformer) {
        boolean replaced = false;
        int i = 0;
        for (E it : list2) {
            if (filter2.isSatisfiedBy(it)) {
                list2.set(i, transformer.transform(it));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public static <K, V> void collectMap(Map<K, V> destination, Iterable<? extends V> items2, Transformer<? extends K, ? super V> keyGenerator) {
        for (V item : items2) {
            destination.put(keyGenerator.transform(item), item);
        }
    }

    public static <K, V> Map<K, V> collectMap(Iterable<? extends V> items2, Transformer<? extends K, ? super V> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMap(map, items2, keyGenerator);
        return map;
    }

    public static <K, V> void collectMapValues(Map<K, V> destination, Iterable<? extends K> keys, Transformer<? extends V, ? super K> keyGenerator) {
        for (K item : keys) {
            destination.put(item, keyGenerator.transform(item));
        }
    }

    public static <K, V> Map<K, V> collectMapValues(Iterable<? extends K> keys, Transformer<? extends V, ? super K> keyGenerator) {
        LinkedHashMap map = new LinkedHashMap();
        CollectionUtils.collectMapValues(map, keys, keyGenerator);
        return map;
    }

    public static <T> boolean every(Iterable<? extends T> things, Spec<? super T> predicate) {
        for (T thing : things) {
            if (predicate.isSatisfiedBy(thing)) continue;
            return false;
        }
        return true;
    }

    public static <T, C extends Collection<? super T>> C addAll(C t1, Iterable<? extends T> t2) {
        for (T t : t2) {
            t1.add(t);
        }
        return t1;
    }

    public static <T, C extends Collection<? super T>> C addAll(C t1, T ... t2) {
        Collections.addAll(t1, t2);
        return t1;
    }

    public static <T> SetDiff<T> diffSetsBy(Set<? extends T> left, Set<? extends T> right, Transformer<?, T> compareBy2) {
        if (left == null) {
            throw new NullPointerException("'left' set is null");
        }
        if (right == null) {
            throw new NullPointerException("'right' set is null");
        }
        SetDiff setDiff = new SetDiff();
        Map<?, T> indexedLeft = CollectionUtils.collectMap(left, compareBy2);
        Map<?, T> indexedRight = CollectionUtils.collectMap(right, compareBy2);
        for (Map.Entry<?, T> leftEntry : indexedLeft.entrySet()) {
            T rightValue = indexedRight.remove(leftEntry.getKey());
            if (rightValue == null) {
                setDiff.leftOnly.add(leftEntry.getValue());
                continue;
            }
            Pair<T, T> pair = Pair.of(leftEntry.getValue(), rightValue);
            setDiff.common.add(pair);
        }
        for (Map.Entry<?, ? extends T> rightValue : indexedRight.values()) {
            setDiff.rightOnly.add(rightValue);
        }
        return setDiff;
    }

    public static String join(String separator, Object[] objects) {
        return CollectionUtils.join(separator, objects == null ? null : Arrays.asList(objects));
    }

    public static String join(String separator, Iterable<?> objects) {
        if (separator == null) {
            throw new NullPointerException("The 'separator' cannot be null");
        }
        if (objects == null) {
            throw new NullPointerException("The 'objects' cannot be null");
        }
        StringBuilder string2 = new StringBuilder();
        Iterator<?> iterator2 = objects.iterator();
        if (iterator2.hasNext()) {
            string2.append(iterator2.next().toString());
            while (iterator2.hasNext()) {
                string2.append(separator);
                string2.append(iterator2.next().toString());
            }
        }
        return string2.toString();
    }

    public static <T> Pair<Collection<T>, Collection<T>> partition(Iterable<T> items2, Spec<? super T> predicate) {
        Preconditions.checkNotNull(items2, "Cannot partition null Collection");
        Preconditions.checkNotNull(predicate, "Cannot apply null Spec when partitioning");
        LinkedList<T> left = new LinkedList<T>();
        LinkedList<T> right = new LinkedList<T>();
        for (T item : items2) {
            if (predicate.isSatisfiedBy(item)) {
                left.add(item);
                continue;
            }
            right.add(item);
        }
        return Pair.of(left, right);
    }

    public static <T, I> T inject(T target, Iterable<? extends I> items2, Action<InjectionStep<T, I>> action) {
        if (target == null) {
            throw new NullPointerException("The 'target' cannot be null");
        }
        if (items2 == null) {
            throw new NullPointerException("The 'items' cannot be null");
        }
        if (action == null) {
            throw new NullPointerException("The 'action' cannot be null");
        }
        for (I item : items2) {
            action.execute(new InjectionStep<T, I>(target, item));
        }
        return target;
    }

    public static <K, V> Map<K, Collection<V>> groupBy(Iterable<? extends V> iterable, Transformer<? extends K, V> grouper) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (V element : iterable) {
            K key = grouper.transform(element);
            builder.put((Object)key, (Object)element);
        }
        return builder.build().asMap();
    }

    public static <T> Iterable<? extends T> unpack(final Iterable<? extends Factory<? extends T>> factories) {
        return new Iterable<T>(){
            private final Iterator<? extends Factory<? extends T>> delegate;
            {
                this.delegate = factories.iterator();
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return delegate.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Factory)delegate.next()).create();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Iterable<T> iterable) {
        ImmutableList<T> list2 = ImmutableList.copyOf(iterable);
        return list2.isEmpty() ? null : list2;
    }

    public static String asCommandLine(Iterable<String> arguments2) {
        return Joiner.on(" ").join(CollectionUtils.collect(arguments2, Transformers.asSafeCommandLineArgument()));
    }

    public static class InjectionStep<T, I> {
        private final T target;
        private final I item;

        public InjectionStep(T target, I item) {
            this.target = target;
            this.item = item;
        }

        public T getTarget() {
            return this.target;
        }

        public I getItem() {
            return this.item;
        }
    }

    public static class SetDiff<T> {
        public Set<T> leftOnly = new HashSet<T>();
        public Set<Pair<T, T>> common = new HashSet<Pair<T, T>>();
        public Set<T> rightOnly = new HashSet<T>();
    }
}

