/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.temporaryVals;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.StoreLoadFrame;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.StoreLoadInterpreter;
import org.jetbrains.kotlin.codegen.optimization.temporaryVals.StoreLoadValue;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010\u001f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0007H\u0002J\u001b\u0010%\u001a\u00020\"2\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0000\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020\"H\u0002J\u001e\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u001a2\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010-\u001a\u00020\u001aH\u0002J.\u0010.\u001a\u00020\"2\u0006\u0010/\u001a\u0002002\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u00020\u001aH\u0002J\u001e\u00103\u001a\u00020\"2\u0006\u0010/\u001a\u0002042\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u001e\u00105\u001a\u00020\"2\u0006\u0010/\u001a\u0002062\f\u0010&\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\f\u00107\u001a\u00020\u001a*\u00020\u0014H\u0002R\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R6\u0010\u0013\u001a(\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0014\u0012\u000e\b\u0001\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/FastStoreLoadAnalyzer;", "V", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadValue;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadInterpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadInterpreter;)V", "frames", "", "Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadFrame;", "[Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadFrame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "insnsArray", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isMergeNode", "", "nInsns", "", "queue", "", "queued", "top", "analyze", "()[Lorg/jetbrains/kotlin/codegen/optimization/temporaryVals/StoreLoadFrame;", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "initLocals", "current", "initLocals$backend", "initMergeNodes", "mergeControlFlowEdge", "dest", "frame", "newFrame", "maxLocals", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insn", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "indexOf", "backend"})
@SourceDebugExtension(value={"SMAP\nFastStoreLoadAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FastStoreLoadAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/FastStoreLoadAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,292:1\n1855#2,2:293\n12474#3,2:295\n*S KotlinDebug\n*F\n+ 1 FastStoreLoadAnalyzer.kt\norg/jetbrains/kotlin/codegen/optimization/temporaryVals/FastStoreLoadAnalyzer\n*L\n162#1:293,2\n185#1:295,2\n*E\n"})
public final class FastStoreLoadAnalyzer<V extends StoreLoadValue> {
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final StoreLoadInterpreter<V> interpreter;
    private final AbstractInsnNode[] insnsArray;
    private final int nInsns;
    @NotNull
    private final boolean[] isMergeNode;
    @NotNull
    private final StoreLoadFrame<V>[] frames;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public FastStoreLoadAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull StoreLoadInterpreter<V> interpreter2) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(interpreter2, "interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter2;
        this.insnsArray = this.method.instructions.toArray();
        this.nInsns = this.method.instructions.size();
        this.isMergeNode = new boolean[this.nInsns];
        this.frames = new StoreLoadFrame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    @NotNull
    public final StoreLoadFrame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        this.initMergeNodes();
        StoreLoadFrame<V> current = this.newFrame(this.method.maxLocals);
        StoreLoadFrame<V> handler2 = this.newFrame(this.method.maxLocals);
        this.initLocals$backend(current);
        this.mergeControlFlowEdge(0, current);
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            Intrinsics.checkNotNull(this.frames[insn]);
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            try {
                StoreLoadFrame<V> f;
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                switch (insnType) {
                    case 8: 
                    case 14: 
                    case 15: {
                        this.mergeControlFlowEdge(insn + 1, f);
                        break;
                    }
                    default: {
                        StoreLoadFrame<V> storeLoadFrame = current.init(f);
                        Intrinsics.checkNotNullExpressionValue(insnNode, "insnNode");
                        storeLoadFrame.execute(insnNode, this.interpreter);
                        if (insnType == 7) {
                            this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
                            break;
                        }
                        if (insnType == 12) {
                            this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current);
                            break;
                        }
                        if (insnType == 11) {
                            this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current);
                            break;
                        }
                        if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                        this.mergeControlFlowEdge(insn + 1, current);
                    }
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.handler");
                    int jump = this.indexOf(labelNode);
                    handler2.init(f);
                    this.mergeControlFlowEdge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                AbstractInsnNode abstractInsnNode = e.node;
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue(insnList, "method.instructions");
                throw new AnalyzerException(abstractInsnNode, stringBuilder.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).toString(), e);
            }
            catch (Exception e) {
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue(insnList, "method.instructions");
                throw new AnalyzerException(insnNode, stringBuilder.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).toString(), e);
            }
        }
        return this.frames;
    }

    private final StoreLoadFrame<V> newFrame(int maxLocals) {
        return new StoreLoadFrame(maxLocals);
    }

    private final int indexOf(AbstractInsnNode $this$indexOf) {
        return this.method.instructions.indexOf($this$indexOf);
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullExpressionValue(this.insnsArray, "insnsArray");
            Object[] $this$any$iv = this.insnsArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                boolean bl2 = false;
                if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, StoreLoadFrame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.dflt");
        this.mergeControlFlowEdge(this.indexOf(labelNode), current);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue(label, "label");
            this.mergeControlFlowEdge(this.indexOf(label), current);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, StoreLoadFrame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.dflt");
        this.mergeControlFlowEdge(this.indexOf(labelNode), current);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue(label, "label");
            this.mergeControlFlowEdge(this.indexOf(label), current);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, StoreLoadFrame<V> current, int insn, int insnOpcode) {
        if (insnOpcode != 167) {
            this.mergeControlFlowEdge(insn + 1, current);
        }
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue(labelNode, "insnNode.label");
        this.mergeControlFlowEdge(this.indexOf(labelNode), current);
    }

    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.start");
            int begin = this.indexOf(labelNode);
            LabelNode labelNode2 = tcb.end;
            Intrinsics.checkNotNullExpressionValue(labelNode2, "tcb.end");
            int end = this.indexOf(labelNode2);
            for (int j = begin; j < end; ++j) {
                AbstractInsnNode abstractInsnNode = this.insnsArray[j];
                Intrinsics.checkNotNullExpressionValue(abstractInsnNode, "insnsArray[j]");
                if (!UtilKt.isMeaningful(abstractInsnNode)) continue;
                List insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = (List)new SmartList();
                }
                Intrinsics.checkNotNullExpressionValue(tcb, "tcb");
                insnHandlers.add(tcb);
            }
        }
    }

    private final void initMergeNodes() {
        Intrinsics.checkNotNullExpressionValue(this.insnsArray, "insnsArray");
        block5: for (AbstractInsnNode insn : this.insnsArray) {
            switch (insn.getType()) {
                case 7: {
                    Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                    JumpInsnNode jumpInsn = (JumpInsnNode)insn;
                    LabelNode labelNode = jumpInsn.label;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "jumpInsn.label");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    continue block5;
                }
                case 12: {
                    Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    AbstractInsnNode switchInsn = (LookupSwitchInsnNode)insn;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "switchInsn.dflt");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    for (LabelNode label : switchInsn.labels) {
                        Intrinsics.checkNotNullExpressionValue(label, "label");
                        this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                    }
                    continue block5;
                }
                case 11: {
                    Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    AbstractInsnNode switchInsn = (TableSwitchInsnNode)insn;
                    LabelNode labelNode = ((TableSwitchInsnNode)switchInsn).dflt;
                    Intrinsics.checkNotNullExpressionValue(labelNode, "switchInsn.dflt");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    for (LabelNode label : ((TableSwitchInsnNode)switchInsn).labels) {
                        Intrinsics.checkNotNullExpressionValue(label, "label");
                        this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                    }
                    continue block5;
                }
            }
        }
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            LabelNode labelNode = tcb.handler;
            Intrinsics.checkNotNullExpressionValue(labelNode, "tcb.handler");
            this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
        }
    }

    public final void initLocals$backend(@NotNull StoreLoadFrame<V> current) {
        Intrinsics.checkNotNullParameter(current, "current");
        Type[] args2 = Type.getArgumentTypes(this.method.desc);
        int local = 0;
        if ((this.method.access & 8) == 0) {
            Type ctype = Type.getObjectType(this.owner);
            int n = local++;
            Intrinsics.checkNotNullExpressionValue(ctype, "ctype");
            current.set(n, this.interpreter.valueParameter(ctype));
        }
        Intrinsics.checkNotNullExpressionValue(args2, "args");
        for (Type arg : args2) {
            int n = local++;
            Intrinsics.checkNotNullExpressionValue(arg, "arg");
            current.set(n, this.interpreter.valueParameter(arg));
            if (arg.getSize() != 2) continue;
            current.set(local++, this.interpreter.uninitialized());
        }
        while (local < this.method.maxLocals) {
            current.set(local++, this.interpreter.uninitialized());
        }
    }

    private final void mergeControlFlowEdge(int dest, StoreLoadFrame<V> frame) {
        boolean changes;
        boolean bl;
        StoreLoadFrame<V> oldFrame = this.frames[dest];
        if (oldFrame == null) {
            this.frames[dest] = this.newFrame(frame.getMaxLocals()).init(frame);
            bl = true;
        } else if (!this.isMergeNode[dest]) {
            oldFrame.init(frame);
            bl = true;
        } else {
            bl = changes = oldFrame.merge(frame, this.interpreter);
        }
        if (changes && !this.queued[dest]) {
            this.queued[dest] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = dest;
        }
    }
}

