/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassUtil {
    @NotNull
    public static Class<?> typeToClass(@NotNull Type type2) {
        if (type2 == null) {
            ClassUtil.$$$reportNull$$$0(0);
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(1);
            }
            return clazz;
        }
        if (type2 instanceof TypeVariable) {
            Type bound = ((TypeVariable)type2).getBounds()[0];
            Class clazz = bound instanceof Class ? (Class)bound : (Class)((ParameterizedType)bound).getRawType();
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(2);
            }
            return clazz;
        }
        if (type2 instanceof WildcardType) {
            Class clazz = (Class)((WildcardType)type2).getUpperBounds()[0];
            if (clazz == null) {
                ClassUtil.$$$reportNull$$$0(3);
            }
            return clazz;
        }
        Class clazz = (Class)((ParameterizedType)type2).getRawType();
        if (clazz == null) {
            ClassUtil.$$$reportNull$$$0(4);
        }
        return clazz;
    }

    public static boolean isPrimitive(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ClassUtil.$$$reportNull$$$0(5);
        }
        return aClass.isPrimitive() || aClass == String.class || aClass == Integer.class || aClass == Long.class || aClass == Boolean.class || aClass == Double.class || aClass == Float.class || aClass.isEnum() || Date.class.isAssignableFrom(aClass);
    }

    public static boolean isMutableCollection(@NotNull Object object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(6);
        }
        if (object == Collections.emptyList() || object == Collections.emptySet()) {
            return false;
        }
        if (object instanceof Collection) {
            Class<?> aClass = object.getClass();
            String simpleName2 = aClass.getSimpleName();
            if (simpleName2.equals("EmptyList") || simpleName2.startsWith("Unmodifiable") || simpleName2.equals("EmptySet")) {
                return false;
            }
            String fullName = aClass.getName();
            if (fullName.equals("java.util.Arrays$ArrayList") || fullName.equals("java.util.Collections$SingletonList") || fullName.equals("java.util.Collections$SingletonSet")) {
                return false;
            }
            Class<?> declaringClass = aClass.getDeclaringClass();
            return declaringClass == null || !"ImmutableCollections".equals(declaringClass.getSimpleName());
        }
        return false;
    }

    public static boolean isMutableMap(@NotNull Map<?, ?> object) {
        if (object == null) {
            ClassUtil.$$$reportNull$$$0(7);
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        String simpleName2 = object.getClass().getSimpleName();
        return !simpleName2.equals("EmptyMap") && !simpleName2.equals("UnmodifiableMap");
    }

    @Nullable
    public static Object stringToEnum(@NotNull String value2, @NotNull Class<? extends Enum<?>> valueClass, boolean isAlwaysIgnoreCase) {
        if (value2 == null) {
            ClassUtil.$$$reportNull$$$0(8);
        }
        if (valueClass == null) {
            ClassUtil.$$$reportNull$$$0(9);
        }
        Enum<?>[] enumConstants = valueClass.getEnumConstants();
        if (!isAlwaysIgnoreCase) {
            for (Enum<?> enumConstant : enumConstants) {
                if (!enumConstant.toString().equals(value2)) continue;
                return enumConstant;
            }
        }
        for (Enum<?> enumConstant : enumConstants) {
            if (!enumConstant.toString().equalsIgnoreCase(value2)) continue;
            return enumConstant;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/serialization/ClassUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/serialization/ClassUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "typeToClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "typeToClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPrimitive";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isMutableCollection";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isMutableMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stringToEnum";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

