/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.SafeMath;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortIterable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortPredicate;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterators;

public interface ShortCollection
extends ShortIterable,
Collection<Short> {
    @Override
    public ShortIterator iterator();

    @Override
    default public ShortSpliterator spliterator() {
        return ShortSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(short var1);

    public boolean contains(short var1);

    public boolean rem(short var1);

    @Override
    @Deprecated
    default public boolean add(Short key) {
        return this.add((short)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Short)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Short)key);
    }

    public short[] toShortArray();

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Short> filter2) {
        return this.removeIf(filter2 instanceof ShortPredicate ? (ShortPredicate)filter2 : key -> filter2.test(SafeMath.safeIntToShort(key)));
    }

    default public boolean removeIf(ShortPredicate filter2) {
        Objects.requireNonNull(filter2);
        boolean removed = false;
        ShortIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter2.test(each.nextShort())) continue;
            each.remove();
            removed = true;
        }
        return removed;
    }

    @Override
    @Deprecated
    default public Stream<Short> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Short> parallelStream() {
        return Collection.super.parallelStream();
    }
}

