/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002J.\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaTypeAccessibilityChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkType", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "findInaccessibleJavaClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "type", "findInaccessibleJavaClassesRec", "scopeOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "inaccessibleClasses", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "frontend.java"})
public final class JavaTypeAccessibilityChecker
implements AdditionalTypeChecker {
    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Collection<ClassDescriptor> inaccessibleClassesWithSmartCast;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(expressionType, "expressionType");
        Intrinsics.checkNotNullParameter(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, "c");
        if (c.isDebuggerContext) {
            return;
        }
        Collection<ClassDescriptor> inaccessibleClasses = this.findInaccessibleJavaClasses(expressionType, c);
        if (!inaccessibleClasses.isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType, inaccessibleClasses));
            return;
        }
        if (!Intrinsics.areEqual(expressionTypeWithSmartCast, expressionType) && !(inaccessibleClassesWithSmartCast = this.findInaccessibleJavaClasses(expressionTypeWithSmartCast, c)).isEmpty()) {
            c.trace.report(Errors.INACCESSIBLE_TYPE.on((KtExpression)((PsiElement)expression2), expressionType, inaccessibleClassesWithSmartCast));
        }
    }

    private final Collection<ClassDescriptor> findInaccessibleJavaClasses(KotlinType type2, ResolutionContext<?> c) {
        DeclarationDescriptor scopeOwner = c.scope.getOwnerDescriptor();
        LinkedHashSet inaccessibleJavaClasses = new LinkedHashSet();
        Collection collection = inaccessibleJavaClasses;
        LanguageVersionSettings languageVersionSettings2 = c.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings2, "c.languageVersionSettings");
        this.findInaccessibleJavaClassesRec(type2, scopeOwner, collection, languageVersionSettings2);
        return inaccessibleJavaClasses;
    }

    private final void findInaccessibleJavaClassesRec(KotlinType type2, DeclarationDescriptor scopeOwner, Collection<ClassDescriptor> inaccessibleClasses, LanguageVersionSettings languageVersionSettings2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof JavaClassDescriptor && !DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((Object)declarationDescriptor), scopeOwner, languageVersionSettings2)) {
            inaccessibleClasses.add((ClassDescriptor)declarationDescriptor);
        }
        for (TypeProjection typeProjection : type2.getArguments()) {
            if (typeProjection.isStarProjection()) continue;
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "typeProjection.type");
            this.findInaccessibleJavaClassesRec(kotlinType, scopeOwner, inaccessibleClasses, languageVersionSettings2);
        }
    }
}

