/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.api.sensors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.slf4j.Logger;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.analyzer.commons.ProgressReport;
import org.sonarsource.kotlin.api.checks.InputFileContext;
import org.sonarsource.kotlin.api.checks.InputFileContextImpl;
import org.sonarsource.kotlin.api.common.MeasureDurationKt;
import org.sonarsource.kotlin.api.frontend.Environment;
import org.sonarsource.kotlin.api.frontend.KotlinSyntaxStructure;
import org.sonarsource.kotlin.api.frontend.KotlinTree;
import org.sonarsource.kotlin.api.frontend.ParseException;
import org.sonarsource.kotlin.api.frontend.RegexCache;
import org.sonarsource.kotlin.api.sensors.AbstractKotlinSensorExecuteContextKt;
import org.sonarsource.kotlin.api.visiting.KotlinFileVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020#J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00180\n2\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020,2\u0006\u00106\u001a\u00020\u00062\u0006\u00107\u001a\u000208H\u0002R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R-\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\n0\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\u001f\u0010 R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001c\u001a\u0004\b\"\u0010$R!\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u001c\u001a\u0004\b(\u0010)R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lorg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext;", "", "sensorContext", "Lorg/sonar/api/batch/sensor/SensorContext;", "inputFiles", "", "Lorg/sonar/api/batch/fs/InputFile;", "progressReport", "Lorg/sonarsource/analyzer/commons/ProgressReport;", "visitors", "", "Lorg/sonarsource/kotlin/api/visiting/KotlinFileVisitor;", "filenames", "", "logger", "Lorg/slf4j/Logger;", "(Lorg/sonar/api/batch/sensor/SensorContext;Ljava/lang/Iterable;Lorg/sonarsource/analyzer/commons/ProgressReport;Ljava/util/List;Ljava/util/List;Lorg/slf4j/Logger;)V", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "diagnostics", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getDiagnostics", "()Ljava/util/Map;", "diagnostics$delegate", "Lkotlin/Lazy;", "environment", "Lorg/sonarsource/kotlin/api/frontend/Environment;", "getEnvironment", "()Lorg/sonarsource/kotlin/api/frontend/Environment;", "environment$delegate", "isInAndroidContext", "", "()Z", "isInAndroidContext$delegate", "kotlinFiles", "Lorg/sonarsource/kotlin/api/frontend/KotlinSyntaxStructure;", "getKotlinFiles", "()Ljava/util/List;", "kotlinFiles$delegate", "analyzeFile", "", "inputFileContext", "Lorg/sonarsource/kotlin/api/checks/InputFileContext;", "tree", "Lorg/sonarsource/kotlin/api/frontend/KotlinTree;", "analyzeFiles", "getFileDiagnostics", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "logParsingError", "inputFile", "e", "Lorg/sonarsource/kotlin/api/frontend/ParseException;", "sonar-kotlin-api"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinSensorExecuteContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinSensorExecuteContext.kt\norg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,194:1\n766#2:195\n857#2,2:196\n1855#2,2:198\n1855#2,2:200\n1#3:202\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinSensorExecuteContext.kt\norg/sonarsource/kotlin/api/sensors/AbstractKotlinSensorExecuteContext\n*L\n93#1:195\n93#1:196,2\n95#1:198,2\n115#1:200,2\n*E\n"})
public abstract class AbstractKotlinSensorExecuteContext {
    @NotNull
    private final SensorContext sensorContext;
    @NotNull
    private final Iterable<InputFile> inputFiles;
    @NotNull
    private final ProgressReport progressReport;
    @NotNull
    private final List<KotlinFileVisitor> visitors;
    @NotNull
    private final List<String> filenames;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy isInAndroidContext$delegate;
    @NotNull
    private final Lazy environment$delegate;
    @NotNull
    private final Lazy kotlinFiles$delegate;
    @NotNull
    private final Lazy diagnostics$delegate;

    public AbstractKotlinSensorExecuteContext(@NotNull SensorContext sensorContext, @NotNull Iterable<? extends InputFile> inputFiles, @NotNull ProgressReport progressReport, @NotNull List<? extends KotlinFileVisitor> visitors, @NotNull List<String> filenames, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(sensorContext, "sensorContext");
        Intrinsics.checkNotNullParameter(inputFiles, "inputFiles");
        Intrinsics.checkNotNullParameter(progressReport, "progressReport");
        Intrinsics.checkNotNullParameter(visitors, "visitors");
        Intrinsics.checkNotNullParameter(filenames, "filenames");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.sensorContext = sensorContext;
        this.inputFiles = inputFiles;
        this.progressReport = progressReport;
        this.visitors = visitors;
        this.filenames = filenames;
        this.logger = logger;
        this.isInAndroidContext$delegate = LazyKt.lazy((Function0)new Function0<Boolean>(this){
            final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                return AbstractKotlinSensorExecuteContext.access$getSensorContext$p(this.this$0).config().getBoolean("sonar.android.detected").orElse(false);
            }
        });
        this.environment$delegate = LazyKt.lazy((Function0)new Function0<Environment>(this){
            final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Environment invoke() {
                return AbstractKotlinSensorExecuteContextKt.environment(AbstractKotlinSensorExecuteContext.access$getSensorContext$p(this.this$0), AbstractKotlinSensorExecuteContext.access$getLogger$p(this.this$0));
            }
        });
        this.kotlinFiles$delegate = LazyKt.lazy((Function0)new Function0<List<? extends KotlinSyntaxStructure>>(this){
            final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<KotlinSyntaxStructure> invoke() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = AbstractKotlinSensorExecuteContext.access$getInputFiles$p(this.this$0);
                AbstractKotlinSensorExecuteContext abstractKotlinSensorExecuteContext = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var4_4 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    KotlinSyntaxStructure it$iv$iv;
                    KotlinSyntaxStructure kotlinSyntaxStructure;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    InputFile it = (InputFile)element$iv$iv;
                    boolean bl2 = false;
                    InputFileContextImpl inputFileContext = new InputFileContextImpl(AbstractKotlinSensorExecuteContext.access$getSensorContext$p(abstractKotlinSensorExecuteContext), it, AbstractKotlinSensorExecuteContext.access$isInAndroidContext(abstractKotlinSensorExecuteContext));
                    try {
                        String string2 = it.contents();
                        Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
                        kotlinSyntaxStructure = KotlinSyntaxStructure.Companion.of(string2, abstractKotlinSensorExecuteContext.getEnvironment(), it);
                    }
                    catch (ParseException e) {
                        AbstractKotlinSensorExecuteContext.access$logParsingError(abstractKotlinSensorExecuteContext, it, AbstractKotlinSensorExecuteContextKt.access$toParseException("parse", it, e));
                        inputFileContext.reportAnalysisParseError("kotlin", it, e.getPosition());
                        kotlinSyntaxStructure = null;
                    }
                    catch (Exception e) {
                        ParseException parseException = AbstractKotlinSensorExecuteContextKt.access$toParseException("read", it, e);
                        AbstractKotlinSensorExecuteContext.access$logParsingError(abstractKotlinSensorExecuteContext, it, parseException);
                        inputFileContext.reportAnalysisParseError("kotlin", it, parseException.getPosition());
                        kotlinSyntaxStructure = null;
                    }
                    if (kotlinSyntaxStructure == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        this.diagnostics$delegate = LazyKt.lazy((Function0)new Function0<Map<PsiFile, ? extends List<? extends Diagnostic>>>(this){
            final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<PsiFile, List<Diagnostic>> invoke() {
                return (Map)MeasureDurationKt.measureDuration("Diagnostics", (Function0)new Function0<Map<PsiFile, ? extends List<? extends Diagnostic>>>(this.this$0){
                    final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final Map<PsiFile, List<Diagnostic>> invoke() {
                        void $this$groupByTo$iv$iv;
                        Iterable $this$groupBy$iv = this.this$0.getBindingContext().getDiagnostics().noSuppression();
                        boolean $i$f$groupBy = false;
                        Iterable iterable = $this$groupBy$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$groupByTo = false;
                        for (T element$iv$iv : $this$groupByTo$iv$iv) {
                            Object object;
                            Diagnostic it = (Diagnostic)element$iv$iv;
                            boolean bl = false;
                            PsiFile key$iv$iv = it.getPsiFile();
                            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                            boolean $i$f$getOrPut = false;
                            V value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                            if (value$iv$iv$iv == null) {
                                boolean bl2 = false;
                                List answer$iv$iv$iv = new ArrayList<E>();
                                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                                object = answer$iv$iv$iv;
                            } else {
                                object = value$iv$iv$iv;
                            }
                            List list$iv$iv = (List)object;
                            list$iv$iv.add(element$iv$iv);
                        }
                        return MapsKt.toMap(destination$iv$iv);
                    }
                });
            }
        });
    }

    private final boolean isInAndroidContext() {
        Lazy lazy = this.isInAndroidContext$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (Boolean)t;
    }

    @NotNull
    public final Environment getEnvironment() {
        Lazy lazy = this.environment$delegate;
        return (Environment)lazy.getValue();
    }

    @NotNull
    public final List<KotlinSyntaxStructure> getKotlinFiles() {
        Lazy lazy = this.kotlinFiles$delegate;
        return (List)lazy.getValue();
    }

    @NotNull
    public abstract BindingContext getBindingContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean analyzeFiles() {
        try {
            void $this$filterTo$iv$iv;
            RegexCache regexCache = new RegexCache(null, 1, null);
            this.progressReport.start((Iterable<String>)this.filenames);
            Iterable $this$filter$iv = this.getKotlinFiles();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KotlinSyntaxStructure it = (KotlinSyntaxStructure)element$iv$iv;
                boolean bl = false;
                Regex regex = AbstractKotlinSensorExecuteContextKt.access$getEMPTY_FILE_CONTENT_PATTERN$p();
                String string2 = it.getInputFile().contents();
                Intrinsics.checkNotNullExpressionValue(string2, "contents(...)");
                if (!(!regex.matches(string2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinSyntaxStructure kotlinSyntaxStructure = (KotlinSyntaxStructure)element$iv;
                boolean bl = false;
                KtFile ktFile = kotlinSyntaxStructure.component1();
                Document doc = kotlinSyntaxStructure.component2();
                InputFile inputFile = kotlinSyntaxStructure.component3();
                if (this.sensorContext.isCancelled()) {
                    boolean bl2 = false;
                    return bl2;
                }
                InputFileContextImpl inputFileContext = new InputFileContextImpl(this.sensorContext, inputFile, this.isInAndroidContext());
                KotlinTree tree = new KotlinTree(ktFile, doc, this.getBindingContext(), this.getFileDiagnostics(ktFile), regexCache);
                String string3 = inputFile.filename();
                Intrinsics.checkNotNullExpressionValue(string3, "filename(...)");
                MeasureDurationKt.measureDuration(string3, (Function0)new Function0<Unit>(this, inputFileContext, tree){
                    final /* synthetic */ AbstractKotlinSensorExecuteContext this$0;
                    final /* synthetic */ InputFileContextImpl $inputFileContext;
                    final /* synthetic */ KotlinTree $tree;
                    {
                        this.this$0 = $receiver;
                        this.$inputFileContext = $inputFileContext;
                        this.$tree = $tree;
                        super(0);
                    }

                    public final void invoke() {
                        AbstractKotlinSensorExecuteContext.access$analyzeFile(this.this$0, this.$inputFileContext, this.$tree);
                    }
                });
                this.progressReport.nextFile();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Disposer.dispose(this.getEnvironment().getDisposable());
        }
    }

    private final void analyzeFile(InputFileContext inputFileContext, KotlinTree tree) {
        Iterable $this$forEach$iv = this.visitors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinFileVisitor visitor2 = (KotlinFileVisitor)element$iv;
            boolean bl = false;
            String visitorId = visitor2.getClass().getSimpleName();
            try {
                Intrinsics.checkNotNull(visitorId);
                MeasureDurationKt.measureDuration(visitorId, (Function0)new Function0<Unit>(visitor2, inputFileContext, tree){
                    final /* synthetic */ KotlinFileVisitor $visitor;
                    final /* synthetic */ InputFileContext $inputFileContext;
                    final /* synthetic */ KotlinTree $tree;
                    {
                        this.$visitor = $visitor;
                        this.$inputFileContext = $inputFileContext;
                        this.$tree = $tree;
                        super(0);
                    }

                    public final void invoke() {
                        this.$visitor.scan(this.$inputFileContext, this.$tree);
                    }
                });
            }
            catch (Exception e) {
                inputFileContext.reportAnalysisError(e.getMessage(), null);
                this.logger.error("Cannot analyse '" + inputFileContext.getInputFile() + "' with '" + visitorId + "': " + e.getMessage(), e);
                Boolean bl2 = this.sensorContext.config().getBoolean("sonar.internal.analysis.failFast").orElse(false);
                Intrinsics.checkNotNullExpressionValue(bl2, "orElse(...)");
                if (!bl2.booleanValue()) continue;
                throw new IllegalStateException("Exception in '" + visitorId + "' while analyzing '" + inputFileContext.getInputFile() + "'", e);
            }
        }
    }

    private final List<Diagnostic> getFileDiagnostics(KtFile ktFile) {
        List<Diagnostic> list2 = this.getDiagnostics().get(ktFile);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final Map<PsiFile, List<Diagnostic>> getDiagnostics() {
        Lazy lazy = this.diagnostics$delegate;
        return (Map)lazy.getValue();
    }

    private final void logParsingError(InputFile inputFile, ParseException e) {
        block1: {
            TextPointer position = e.getPosition();
            Object positionMessage = "";
            if (position != null) {
                positionMessage = "Parse error at position " + position.line() + ":" + position.lineOffset();
            }
            this.logger.error("Unable to parse file: " + inputFile.uri() + ". " + (String)positionMessage);
            String string2 = e.getMessage();
            if (string2 == null) break block1;
            String it = string2;
            boolean bl = false;
            this.logger.error(it);
        }
    }

    public static final /* synthetic */ void access$analyzeFile(AbstractKotlinSensorExecuteContext $this, InputFileContext inputFileContext, KotlinTree tree) {
        $this.analyzeFile(inputFileContext, tree);
    }

    public static final /* synthetic */ SensorContext access$getSensorContext$p(AbstractKotlinSensorExecuteContext $this) {
        return $this.sensorContext;
    }

    public static final /* synthetic */ Logger access$getLogger$p(AbstractKotlinSensorExecuteContext $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Iterable access$getInputFiles$p(AbstractKotlinSensorExecuteContext $this) {
        return $this.inputFiles;
    }

    public static final /* synthetic */ boolean access$isInAndroidContext(AbstractKotlinSensorExecuteContext $this) {
        return $this.isInAndroidContext();
    }

    public static final /* synthetic */ void access$logParsingError(AbstractKotlinSensorExecuteContext $this, InputFile inputFile, ParseException e) {
        $this.logParsingError(inputFile, e);
    }
}

