/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"spansMultipleLines", "", "tree", "Lorg/jetbrains/kotlin/psi/KtElement;", "ctx", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "hasSameSignature", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "other", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "sonar-kotlin-checks"})
public final class DuplicateBranchCheckKt {
    private static final boolean hasSameSignature(KtQualifiedExpression $this$hasSameSignature, KtQualifiedExpression other, BindingContext bindingContext2) {
        return Intrinsics.areEqual(ApiExtensionsKt.determineSignature($this$hasSameSignature, bindingContext2), ApiExtensionsKt.determineSignature(other, bindingContext2));
    }

    private static final boolean spansMultipleLines(KtElement tree, KotlinFileContext ctx) {
        if (tree instanceof KtBlockExpression) {
            List<KtExpression> list2 = ((KtBlockExpression)tree).getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
            List<KtExpression> statements = list2;
            if (((Collection)statements).isEmpty()) {
                return false;
            }
            KtExpression firstStatement = statements.get(0);
            KtExpression lastStatement = statements.get(statements.size() - 1);
            Intrinsics.checkNotNull(firstStatement);
            TextRange firstTextRange = KotlinTextRanges.INSTANCE.textRange(ctx, firstStatement);
            Intrinsics.checkNotNull(lastStatement);
            TextRange lastTextRange = KotlinTextRanges.INSTANCE.textRange(ctx, lastStatement);
            return firstTextRange.start().line() != lastTextRange.end().line();
        }
        TextRange range = KotlinTextRanges.INSTANCE.textRange(ctx, tree);
        return range.start().line() < range.end().line();
    }

    public static final /* synthetic */ boolean access$spansMultipleLines(KtElement tree, KotlinFileContext ctx) {
        return DuplicateBranchCheckKt.spansMultipleLines(tree, ctx);
    }

    public static final /* synthetic */ boolean access$hasSameSignature(KtQualifiedExpression $receiver, KtQualifiedExpression other, BindingContext bindingContext2) {
        return DuplicateBranchCheckKt.hasSameSignature($receiver, other, bindingContext2);
    }
}

