/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.gradle.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.KotlinTextRanges;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.api.reporting.MessageKt;
import org.sonarsource.kotlin.gradle.checks.AssignmentChecker;

@Rule(key="S6626")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/sonarsource/kotlin/gradle/checks/TaskDefinitionsCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "getLastArgumentLambdaOrNull", "Lorg/jetbrains/kotlin/psi/KtLambdaArgument;", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isTasksRegisterCall", "", "visitCallExpression", "", "kotlinFileContext", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "sonar-kotlin-gradle"})
public final class TaskDefinitionsCheck
extends AbstractCheck {
    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2, @NotNull KotlinFileContext kotlinFileContext) {
        KtElement ktElement;
        KtValueArgumentList ktValueArgumentList;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        if (!this.isTasksRegisterCall(expression2)) {
            return;
        }
        KtLambdaArgument ktLambdaArgument = this.getLastArgumentLambdaOrNull(expression2);
        if (ktLambdaArgument == null) {
            return;
        }
        KtLambdaArgument lambdaArg = ktLambdaArgument;
        LazyParseablePsiElement lazyParseablePsiElement = lambdaArg.getLambdaExpression();
        if (lazyParseablePsiElement == null || (lazyParseablePsiElement = ((KtLambdaExpression)lazyParseablePsiElement).getBodyExpression()) == null) {
            return;
        }
        LazyParseablePsiElement block = lazyParseablePsiElement;
        AssignmentChecker assignmentChecker = new AssignmentChecker();
        block.acceptChildren(assignmentChecker);
        AssignmentChecker $this$visitCallExpression_u24lambda_u240 = assignmentChecker;
        boolean bl = false;
        if ($this$visitCallExpression_u24lambda_u240.getHasGroup() && $this$visitCallExpression_u24lambda_u240.getHasDescription()) {
            return;
        }
        KtValueArgumentList ktValueArgumentList2 = ktValueArgumentList = expression2.getValueArgumentList();
        if (ktValueArgumentList2 == null) {
            KtExpression ktExpression = org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt.getCalleeExpressionIfAny(expression2);
            Intrinsics.checkNotNull(ktExpression);
            ktElement = ktExpression;
        } else {
            Intrinsics.checkNotNull(ktValueArgumentList2);
            ktElement = ktValueArgumentList;
        }
        KtElement highlightEndElement = ktElement;
        AbstractCheck abstractCheck = this;
        PsiElement psiElement = expression2.getParent();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getParent(...)");
        AbstractCheck.reportIssue$default(abstractCheck, kotlinFileContext, KotlinTextRanges.INSTANCE.textRange(kotlinFileContext, PsiUtilsKt.getStartOffset(psiElement), PsiUtilsKt.getEndOffset(highlightEndElement)), MessageKt.message((Function1<? super Message, Unit>)new Function1<Message, Unit>($this$visitCallExpression_u24lambda_u240){
            final /* synthetic */ AssignmentChecker $this_with;
            {
                this.$this_with = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Message $this$message) {
                Intrinsics.checkNotNullParameter($this$message, "$this$message");
                $this$message.unaryPlus("Define ");
                if (!this.$this_with.getHasGroup()) {
                    $this$message.code("group");
                }
                if (!this.$this_with.getHasGroup() && !this.$this_with.getHasDescription()) {
                    $this$message.unaryPlus(" and ");
                }
                if (!this.$this_with.getHasDescription()) {
                    $this$message.code("description");
                }
                $this$message.unaryPlus(" for this task");
            }
        }), null, null, 12, null);
    }

    private final boolean isTasksRegisterCall(KtCallExpression expression2) {
        String functionName;
        KtExpression ktExpression = org.jetbrains.kotlin.resolve.calls.util.PsiUtilsKt.getCalleeExpressionIfAny(expression2);
        KtNameReferenceExpression ktNameReferenceExpression = ktExpression instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)ktExpression : null;
        String string2 = functionName = ktNameReferenceExpression != null ? ktNameReferenceExpression.getReferencedName() : null;
        if (!Intrinsics.areEqual(functionName, "register") && !Intrinsics.areEqual(functionName, "create")) {
            return false;
        }
        PsiElement psiElement = expression2.getParent();
        KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null) {
            return false;
        }
        KtDotQualifiedExpression parent2 = ktDotQualifiedExpression;
        psiElement = parent2.getReceiverExpression();
        KtNameReferenceExpression ktNameReferenceExpression2 = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
        return Intrinsics.areEqual(ktNameReferenceExpression2 != null ? ktNameReferenceExpression2.getReferencedName() : null, "tasks");
    }

    private final KtLambdaArgument getLastArgumentLambdaOrNull(KtCallExpression expression2) {
        List<KtValueArgument> list2 = expression2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(list2, "getValueArguments(...)");
        KtValueArgument ktValueArgument = CollectionsKt.lastOrNull(list2);
        return ktValueArgument instanceof KtLambdaArgument ? (KtLambdaArgument)ktValueArgument : null;
    }
}

