/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.channel.AbstractChannel;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.core.CoreModuleProperties;

public class LocalWindow
extends Window {
    private final AbstractChannel channel;

    public LocalWindow(AbstractChannel channel, boolean isClient) {
        super(channel, isClient);
        this.channel = channel;
    }

    @Override
    public AbstractChannel getChannel() {
        return this.channel;
    }

    public void init(PropertyResolver resolver) {
        this.init(CoreModuleProperties.WINDOW_SIZE.getRequired(resolver), CoreModuleProperties.MAX_PACKET_SIZE.getRequired(resolver), resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consume(long len) throws IOException {
        long remainLen;
        BufferUtils.validateUint32Value(len, "Invalid consumption length: %d");
        this.checkInitialized("consume");
        Object object = this.lock;
        synchronized (object) {
            remainLen = this.getSize() - len;
            if (remainLen >= 0L) {
                this.updateSize(remainLen);
            }
        }
        if (remainLen < 0L) {
            throw new StreamCorruptedException("consume(" + this + ") required length (" + len + ") above available: " + (remainLen + len));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Consume {} by {} down to {}", this, len, remainLen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() throws IOException {
        this.checkInitialized("check");
        long maxFree = this.getMaxSize();
        long adjustSize = -1L;
        AbstractChannel channel = this.getChannel();
        Object object = this.lock;
        synchronized (object) {
            long size = this.getSize();
            if (size < maxFree / 2L) {
                adjustSize = maxFree - size;
                channel.sendWindowAdjust(adjustSize);
                this.updateSize(maxFree);
            }
        }
        if (adjustSize >= 0L && this.log.isDebugEnabled()) {
            this.log.debug("Increase {} by {} up to {}", this, adjustSize, maxFree);
        }
    }
}

