/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.password;

import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.auth.UserAuthMethodFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.server.auth.AbstractUserAuth;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.PasswordChangeRequiredException;
import org.apache.sshd.server.session.ServerSession;

public class UserAuthPassword
extends AbstractUserAuth {
    public static final String NAME = "password";

    public UserAuthPassword() {
        super(NAME);
    }

    @Override
    public Boolean doAuth(Buffer buffer, boolean init) throws Exception {
        ValidateUtils.checkTrue(init, "Instance not initialized");
        ServerSession session = this.getServerSession();
        if (!UserAuthMethodFactory.isSecureAuthenticationTransport(session)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("doAuth({}) session is not secure", (Object)session);
            }
            return false;
        }
        String username = this.getUsername();
        boolean newPassword = buffer.getBoolean();
        String password = buffer.getString();
        if (newPassword) {
            return this.handleClientPasswordChangeRequest(buffer, session, username, password, buffer.getString());
        }
        return this.checkPassword(buffer, session, username, password);
    }

    protected Boolean checkPassword(Buffer buffer, ServerSession session, String username, String password) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) no password authenticator", (Object)session);
            }
            return false;
        }
        try {
            boolean authed;
            try {
                authed = auth.authenticate(username, password, session);
            }
            catch (Error e) {
                this.warn("checkPassword({}) failed ({}) to consult authenticator: {}", session, e.getClass().getSimpleName(), e.getMessage(), e);
                throw new RuntimeSshException(e);
            }
            if (debugEnabled) {
                this.log.debug("checkPassword({}) authentication result: {}", (Object)session, (Object)authed);
            }
            return authed;
        }
        catch (PasswordChangeRequiredException e) {
            if (debugEnabled) {
                this.log.debug("checkPassword({}) password change required: {}", (Object)session, (Object)e.getMessage());
            }
            return this.handleServerPasswordChangeRequest(buffer, session, username, password, e);
        }
    }

    protected Boolean handleClientPasswordChangeRequest(Buffer buffer, ServerSession session, String username, String oldPassword, String newPassword) throws Exception {
        boolean debugEnabled = this.log.isDebugEnabled();
        if (!UserAuthMethodFactory.isDataIntegrityAuthenticationTransport(session)) {
            if (debugEnabled) {
                this.log.debug("handleClientPasswordChangeRequest({}) session is not validated via MAC", (Object)session);
            }
            return false;
        }
        PasswordAuthenticator auth = session.getPasswordAuthenticator();
        if (auth == null) {
            if (debugEnabled) {
                this.log.debug("handleClientPasswordChangeRequest({}) no password authenticator", (Object)session);
            }
            return false;
        }
        return auth.handleClientPasswordChangeRequest(session, username, oldPassword, newPassword);
    }

    protected Boolean handleServerPasswordChangeRequest(Buffer buffer, ServerSession session, String username, String password, PasswordChangeRequiredException e) throws Exception {
        String prompt = e.getPrompt();
        String lang = e.getLanguage();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handlePasswordChangeRequest({}) password change required - prompt={}, lang={}", session, prompt, lang);
        }
        buffer = session.createBuffer((byte)60, GenericUtils.length(prompt) + GenericUtils.length(lang) + 32);
        buffer.putString(prompt);
        buffer.putString(lang);
        session.writePacket(buffer);
        return null;
    }
}

