/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SideBandInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SideBandInputStream.class);
    static final int CH_DATA = 1;
    static final int CH_PROGRESS = 2;
    static final int CH_ERROR = 3;
    private static Pattern P_UNBOUNDED = Pattern.compile("^([\\w ]+): +(\\d+)(?:, done\\.)? *[\r\n]$");
    private static Pattern P_BOUNDED = Pattern.compile("^([\\w ]+): +\\d+% +\\( *(\\d+)/ *(\\d+)\\)(?:, done\\.)? *[\r\n]$");
    private final InputStream rawIn;
    private final PacketLineIn pckIn;
    private final ProgressMonitor monitor;
    private final Writer messages;
    private final OutputStream out;
    private String progressBuffer = "";
    private String currentTask;
    private int lastCnt;
    private boolean eof;
    private int channel;
    private int available;

    SideBandInputStream(InputStream in, ProgressMonitor progress, Writer messageStream, OutputStream outputStream2) {
        this.rawIn = in;
        this.pckIn = new PacketLineIn(this.rawIn);
        this.monitor = progress;
        this.messages = messageStream;
        this.currentTask = "";
        this.out = outputStream2;
    }

    @Override
    public int read() throws IOException {
        this.needDataPacket();
        if (this.eof) {
            return -1;
        }
        --this.available;
        return this.rawIn.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = 0;
        while (len > 0) {
            int n;
            this.needDataPacket();
            if (this.eof || (n = this.rawIn.read(b, off, Math.min(len, this.available))) < 0) break;
            r += n;
            off += n;
            len -= n;
            this.available -= n;
        }
        return this.eof && r == 0 ? -1 : r;
    }

    private void needDataPacket() throws IOException {
        if (this.eof || this.channel == 1 && this.available > 0) {
            return;
        }
        block5: while (true) {
            this.available = this.pckIn.readLength();
            if (this.available == 0) {
                this.eof = true;
                return;
            }
            this.channel = this.rawIn.read() & 0xFF;
            this.available -= 5;
            if (this.available == 0) continue;
            switch (this.channel) {
                case 1: {
                    return;
                }
                case 2: {
                    this.progress(this.readString(this.available));
                    continue block5;
                }
                case 3: {
                    this.eof = true;
                    throw new TransportException(SideBandInputStream.remote(this.readString(this.available)));
                }
            }
            break;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidChannel, this.channel));
    }

    private void progress(String pkt) throws IOException {
        pkt = String.valueOf(this.progressBuffer) + pkt;
        while (true) {
            int s;
            int lf = pkt.indexOf(10);
            int cr = pkt.indexOf(13);
            if (lf >= 0 && cr >= 0) {
                s = Math.min(lf, cr);
            } else if (lf >= 0) {
                s = lf;
            } else {
                if (cr < 0) break;
                s = cr;
            }
            this.doProgressLine(pkt.substring(0, s + 1));
            pkt = pkt.substring(s + 1);
        }
        this.progressBuffer = pkt;
    }

    private void doProgressLine(String msg) throws IOException {
        Matcher matcher = P_BOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                this.beginTask(Integer.parseInt(matcher.group(3)));
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return;
        }
        matcher = P_UNBOUNDED.matcher(msg);
        if (matcher.matches()) {
            String taskname = matcher.group(1);
            if (!this.currentTask.equals(taskname)) {
                this.currentTask = taskname;
                this.lastCnt = 0;
                this.beginTask(0);
            }
            int cnt = Integer.parseInt(matcher.group(2));
            this.monitor.update(cnt - this.lastCnt);
            this.lastCnt = cnt;
            return;
        }
        this.messages.write(msg);
        if (this.out != null) {
            this.out.write(msg.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void beginTask(int totalWorkUnits) {
        this.monitor.beginTask(SideBandInputStream.remote(this.currentTask), totalWorkUnits);
    }

    void drainMessages() {
        if (!this.progressBuffer.isEmpty()) {
            try {
                this.progress("\n");
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
    }

    private static String remote(String msg) {
        String prefix = JGitText.get().prefixRemote;
        StringBuilder r = new StringBuilder(prefix.length() + msg.length() + 1);
        r.append(prefix);
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) != ' ') {
            r.append(' ');
        }
        r.append(msg);
        return r.toString();
    }

    private String readString(int len) throws IOException {
        byte[] raw = new byte[len];
        IO.readFully(this.rawIn, raw, 0, len);
        return RawParseUtils.decode(StandardCharsets.UTF_8, raw, 0, len);
    }
}

