/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.issue.internal;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.issue.ExternalIssue;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.internal.AbstractDefaultIssue;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.CleanCodeAttribute;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.Preconditions;

public class DefaultExternalIssue
extends AbstractDefaultIssue<DefaultExternalIssue>
implements ExternalIssue,
NewExternalIssue {
    private Long effort;
    private Severity severity;
    private RuleType type;
    private String engineId;
    private String ruleId;
    private Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts = new EnumMap<SoftwareQuality, org.sonar.api.issue.impact.Severity>(SoftwareQuality.class);
    private CleanCodeAttribute cleanCodeAttribute;

    public DefaultExternalIssue(DefaultInputProject project) {
        this(project, null);
    }

    public DefaultExternalIssue(DefaultInputProject project, @Nullable SensorStorage storage) {
        super(project, storage);
    }

    @Override
    public DefaultExternalIssue remediationEffortMinutes(@Nullable Long effort) {
        Preconditions.checkArgument(effort == null || effort >= 0L, String.format("effort must be greater than or equal 0 (got %s)", effort));
        this.effort = effort;
        return this;
    }

    @Override
    public DefaultExternalIssue severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public DefaultExternalIssue addImpact(SoftwareQuality softwareQuality, org.sonar.api.issue.impact.Severity severity) {
        this.impacts.put(softwareQuality, severity);
        return this;
    }

    @Override
    public String engineId() {
        return this.engineId;
    }

    @Override
    public String ruleId() {
        return this.ruleId;
    }

    @Override
    public Severity severity() {
        return this.severity;
    }

    @Override
    public Long remediationEffort() {
        return this.effort;
    }

    @Override
    public void doSave() {
        Objects.requireNonNull(this.engineId, "Engine id is mandatory on external issue");
        Objects.requireNonNull(this.ruleId, "Rule id is mandatory on external issue");
        Preconditions.checkState(this.primaryLocation != null, "Primary location is mandatory on every external issue");
        Preconditions.checkState(this.primaryLocation.message() != null, "External issues must have a message");
        this.storage.store(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    @Override
    public Map<SoftwareQuality, org.sonar.api.issue.impact.Severity> impacts() {
        return this.impacts;
    }

    @Override
    @CheckForNull
    public CleanCodeAttribute cleanCodeAttribute() {
        return this.cleanCodeAttribute;
    }

    @Override
    public NewExternalIssue engineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    @Override
    public NewExternalIssue ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Override
    public DefaultExternalIssue forRule(RuleKey ruleKey) {
        this.engineId = ruleKey.repository();
        this.ruleId = ruleKey.rule();
        return this;
    }

    @Override
    public RuleKey ruleKey() {
        if (this.engineId != null && this.ruleId != null) {
            return RuleKey.of("external_" + this.engineId, this.ruleId);
        }
        return null;
    }

    @Override
    public DefaultExternalIssue type(RuleType type) {
        this.type = type;
        return this;
    }

    @Override
    public DefaultExternalIssue cleanCodeAttribute(CleanCodeAttribute attribute) {
        this.cleanCodeAttribute = attribute;
        return this;
    }
}

