/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.SonarEdition;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.Version;

public class MetadataLoader {
    private static final String SQ_VERSION_FILE_PATH = "/sq-version.txt";
    private static final String SONAR_API_VERSION_FILE_PATH = "/sonar-api-version.txt";
    private static final String EDITION_FILE_PATH = "/sonar-edition.txt";

    private MetadataLoader() {
    }

    public static Version loadApiVersion(System2 system) {
        return MetadataLoader.getVersion(system, SONAR_API_VERSION_FILE_PATH);
    }

    public static Version loadSQVersion(System2 system) {
        return MetadataLoader.getVersion(system, SQ_VERSION_FILE_PATH);
    }

    private static Version getVersion(System2 system, String versionFilePath) {
        URL url = system.getResource(versionFilePath);
        Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());
        try {
            String versionInFile = scanner.nextLine();
            Version version = Version.parse(versionInFile);
            scanner.close();
            return version;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not load " + versionFilePath + " from classpath ", e);
            }
        }
    }

    public static SonarEdition loadEdition(System2 system) {
        URL url = system.getResource(EDITION_FILE_PATH);
        if (url == null) {
            return SonarEdition.COMMUNITY;
        }
        Scanner scanner = new Scanner(url.openStream(), StandardCharsets.UTF_8.name());
        try {
            String editionInFile = scanner.nextLine();
            SonarEdition sonarEdition = MetadataLoader.parseEdition(editionInFile);
            scanner.close();
            return sonarEdition;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Can not load /sonar-edition.txt from classpath", e);
            }
        }
    }

    static SonarEdition parseEdition(String edition) {
        String str = StringUtils.trimToEmpty(edition.toUpperCase(Locale.ENGLISH));
        try {
            return SonarEdition.valueOf(str);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Invalid edition found in '%s': '%s'", EDITION_FILE_PATH, str));
        }
    }
}

