/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.Locale;
import org.sonar.api.resources.Language;
import org.sonar.api.utils.Preconditions;

public abstract class AbstractLanguage
implements Language {
    private final String key;
    private String name;

    public AbstractLanguage(String key) {
        this(key, key);
    }

    public AbstractLanguage(String key, String name) {
        Preconditions.checkArgument(key.length() <= 20, "The following language key exceeds 20 characters: '" + key + "'");
        this.key = key.toLowerCase(Locale.ENGLISH);
        this.name = name;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Language)) {
            return false;
        }
        Language that = (Language)o;
        return this.key.equals(that.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

