/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule.internal;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.rules.RuleType;

@Deprecated(since="10.1")
public class ImpactMapper {
    static final List<SoftwareQuality> ORDERED_SOFTWARE_QUALITIES = List.of(SoftwareQuality.MAINTAINABILITY, SoftwareQuality.RELIABILITY, SoftwareQuality.SECURITY);

    private ImpactMapper() {
    }

    public static SoftwareQuality convertToSoftwareQuality(RuleType ruleType) {
        switch (ruleType) {
            case CODE_SMELL: {
                return SoftwareQuality.MAINTAINABILITY;
            }
            case BUG: {
                return SoftwareQuality.RELIABILITY;
            }
            case VULNERABILITY: {
                return SoftwareQuality.SECURITY;
            }
            case SECURITY_HOTSPOT: {
                throw new IllegalStateException("Can not map Security Hotspot to Software Quality");
            }
        }
        throw new IllegalStateException("Unknown rule type");
    }

    public static RuleType convertToRuleType(SoftwareQuality softwareQuality) {
        switch (softwareQuality) {
            case MAINTAINABILITY: {
                return RuleType.CODE_SMELL;
            }
            case RELIABILITY: {
                return RuleType.BUG;
            }
            case SECURITY: {
                return RuleType.VULNERABILITY;
            }
        }
        throw new IllegalStateException("Unknown software quality");
    }

    public static String convertToDeprecatedSeverity(Severity severity) {
        switch (severity) {
            case HIGH: {
                return "CRITICAL";
            }
            case MEDIUM: {
                return "MAJOR";
            }
            case LOW: {
                return "MINOR";
            }
        }
        throw new IllegalStateException("This severity value " + severity + " is illegal.");
    }

    public static Severity convertToImpactSeverity(String deprecatedSeverity) {
        switch (deprecatedSeverity) {
            case "CRITICAL": 
            case "BLOCKER": {
                return Severity.HIGH;
            }
            case "MAJOR": {
                return Severity.MEDIUM;
            }
            case "MINOR": 
            case "INFO": {
                return Severity.LOW;
            }
        }
        throw new IllegalStateException("This old severity value " + deprecatedSeverity + " is illegal.");
    }

    public static Map.Entry<SoftwareQuality, Severity> getBestImpactForBackmapping(Map<SoftwareQuality, Severity> impacts) {
        return impacts.entrySet().stream().min(Comparator.comparing(i -> ORDERED_SOFTWARE_QUALITIES.indexOf(i.getKey()))).orElseThrow(() -> new IllegalArgumentException("There is no impact to choose from."));
    }
}

