/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.testfixtures.measure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.ce.measure.Settings;
import org.sonar.api.testfixtures.measure.TestMeasure;
import org.sonar.api.utils.Preconditions;

public class TestMeasureComputerContext
implements MeasureComputer.MeasureComputerContext {
    private final Component component;
    private final MeasureComputer.MeasureComputerDefinition definition;
    private final Settings settings;
    private Map<String, Measure> componentMeasureByMetricKey = new HashMap<String, Measure>();
    private Map<String, List<Measure>> childrenComponentMeasureByMetricKey = new HashMap<String, List<Measure>>();
    private List<Issue> issues = new ArrayList<Issue>();

    public TestMeasureComputerContext(Component component, Settings settings, MeasureComputer.MeasureComputerDefinition definition) {
        this.settings = settings;
        this.component = component;
        this.definition = definition;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @CheckForNull
    public Measure getMeasure(String metric) {
        this.validateInputMetric(metric);
        return this.componentMeasureByMetricKey.get(metric);
    }

    @Override
    public Iterable<Measure> getChildrenMeasures(String metric) {
        this.validateInputMetric(metric);
        return this.childrenComponentMeasureByMetricKey.getOrDefault(metric, Collections.emptyList());
    }

    @Override
    public void addMeasure(String metricKey, int value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, int value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Integer ... values2) {
        for (Integer value : values2) {
            this.childrenComponentMeasureByMetricKey.computeIfAbsent(metricKey, x -> new ArrayList()).add(TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, double value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, double value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Double ... values2) {
        for (Double value : values2) {
            this.childrenComponentMeasureByMetricKey.computeIfAbsent(metricKey, x -> new ArrayList()).add(TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, long value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, long value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Long ... values2) {
        for (Long value : values2) {
            this.childrenComponentMeasureByMetricKey.computeIfAbsent(metricKey, x -> new ArrayList()).add(TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, String value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    @Override
    public void addMeasure(String metricKey, boolean value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, boolean value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, String value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, String ... values2) {
        for (String value : values2) {
            this.childrenComponentMeasureByMetricKey.computeIfAbsent(metricKey, x -> new ArrayList()).add(TestMeasure.createMeasure(value));
        }
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    private void validateInputMetric(String metric) {
        HashSet<String> allowedMetrics = new HashSet<String>();
        allowedMetrics.addAll(this.definition.getInputMetrics());
        allowedMetrics.addAll(this.definition.getOutputMetrics());
        Preconditions.checkArgument(allowedMetrics.contains(metric), "Only metrics in %s can be used to load measures", this.definition.getInputMetrics());
    }

    private void validateAddMeasure(String metricKey) {
        Preconditions.checkArgument(this.definition.getOutputMetrics().contains(metricKey), "Only metrics in %s can be used to add measures. Metric '%s' is not allowed.", this.definition.getOutputMetrics(), metricKey);
        if (this.componentMeasureByMetricKey.get(metricKey) != null) {
            throw new UnsupportedOperationException(String.format("A measure on metric '%s' already exists", metricKey));
        }
    }
}

