/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue;

import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.tracking.Trackable;

public class AnticipatedTransition
implements Trackable {
    private final String uuid;
    private final String projectKey;
    private final String transition;
    private final String userUuid;
    private final String comment;
    private final String filePath;
    private final Integer line;
    private final String message;
    private final String lineHash;
    private final RuleKey ruleKey;

    public AnticipatedTransition(@Nullable String uuid, String projectKey, String userUuid, @Nullable RuleKey ruleKey, @Nullable String message, @Nullable String filePath, @Nullable Integer line, @Nullable String lineHash, String transition, @Nullable String comment) {
        this.uuid = uuid;
        this.projectKey = projectKey;
        this.transition = transition;
        this.userUuid = userUuid;
        this.comment = comment;
        this.filePath = filePath;
        this.line = line;
        this.message = message;
        this.lineHash = lineHash;
        this.ruleKey = ruleKey;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getTransition() {
        return this.transition;
    }

    public String getUserUuid() {
        return this.userUuid;
    }

    public String getComment() {
        return this.comment;
    }

    public String getFilePath() {
        return this.filePath;
    }

    @Override
    @Nullable
    public Integer getLine() {
        return this.line;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nullable
    public String getLineHash() {
        return this.lineHash;
    }

    @Override
    public RuleKey getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public String getStatus() {
        return "OPEN";
    }

    @Override
    public Date getUpdateDate() {
        return Date.from(Instant.now());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnticipatedTransition that = (AnticipatedTransition)o;
        return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.transition, that.transition) && Objects.equals(this.userUuid, that.userUuid) && Objects.equals(this.comment, that.comment) && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.line, that.line) && Objects.equals(this.message, that.message) && Objects.equals(this.lineHash, that.lineHash) && Objects.equals(this.ruleKey, that.ruleKey);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    public String getUuid() {
        return this.uuid;
    }
}

