/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.collect.ArrayListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.core.issue.tracking.Tracking;

public class AbstractTracker<RAW extends Trackable, BASE extends Trackable> {
    protected void match(Tracking<RAW, BASE> tracking, Function<Trackable, SearchKey> searchKeyFactory) {
        if (tracking.isComplete()) {
            return;
        }
        ArrayListMultimap baseSearch = ArrayListMultimap.create();
        tracking.getUnmatchedBases().forEach(base -> baseSearch.put((SearchKey)searchKeyFactory.apply((Trackable)base), base));
        tracking.getUnmatchedRaws().forEach(raw -> {
            SearchKey rawKey = (SearchKey)searchKeyFactory.apply((Trackable)raw);
            Collection bases = baseSearch.get(rawKey);
            bases.stream().sorted(Comparator.comparing(Trackable::getUpdateDate).reversed()).findFirst().ifPresent(match -> {
                tracking.match(raw, match);
                baseSearch.remove(rawKey, match);
            });
        });
    }

    protected static interface SearchKey {
    }

    protected static class LineHashKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String lineHash;

        LineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineHashKey that = (LineHashKey)o;
            return this.lineHash.equals(that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleKey, this.lineHash);
        }
    }

    protected static class LineAndMessageKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String message;
        private final Integer line;

        LineAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.line = trackable.getLine();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineAndMessageKey that = (LineAndMessageKey)o;
            return Objects.equals(this.line, that.line) && Objects.equals(this.message, that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleKey, this.message, this.line != null ? this.line : 0);
        }
    }

    protected static class LineHashAndMessageKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String message;
        private final String lineHash;

        LineHashAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineHashAndMessageKey that = (LineHashAndMessageKey)o;
            return this.lineHash.equals(that.lineHash) && Objects.equals(this.message, that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleKey, this.message, this.lineHash);
        }
    }

    protected static class LineAndLineHashAndMessage
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String lineHash;
        private final String message;
        private final Integer line;

        protected LineAndLineHashAndMessage(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.message = trackable.getMessage();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineAndLineHashAndMessage that = (LineAndLineHashAndMessage)o;
            return Objects.equals(this.line, that.line) && this.lineHash.equals(that.lineHash) && Objects.equals(this.message, that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleKey, this.lineHash, this.message, this.line != null ? this.line : 0);
        }
    }

    protected static class LineAndLineHashKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String lineHash;
        private final Integer line;

        protected LineAndLineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(@Nonnull Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineAndLineHashKey that = (LineAndLineHashKey)o;
            return Objects.equals(this.line, that.line) && this.lineHash.equals(that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            return Objects.hash(this.ruleKey, this.lineHash, this.line != null ? this.line : 0);
        }
    }
}

