/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.sonar.core.issue.tracking.BlockHashSequence;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.core.issue.tracking.Trackable;

class FilteringBaseInputWrapper<BASE extends Trackable>
implements Input<BASE> {
    private final Input<BASE> baseInput;
    private final List<BASE> nonClosedIssues;

    public FilteringBaseInputWrapper(Input<BASE> baseInput, Predicate<BASE> baseInputFilter) {
        this.baseInput = baseInput;
        Collection<BASE> baseIssues = baseInput.getIssues();
        this.nonClosedIssues = baseIssues.stream().filter(baseInputFilter).collect(Collectors.toList());
    }

    @Override
    public LineHashSequence getLineHashSequence() {
        return this.baseInput.getLineHashSequence();
    }

    @Override
    public BlockHashSequence getBlockHashSequence() {
        return this.baseInput.getBlockHashSequence();
    }

    @Override
    public Collection<BASE> getIssues() {
        return this.nonClosedIssues;
    }
}

