/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.metric;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.Metrics;
import org.sonar.api.scanner.ScannerSide;
import org.springframework.beans.factory.annotation.Autowired;

@ComputeEngineSide
@ScannerSide
@Immutable
public class ScannerMetrics {
    private static final Set<Metric> ALLOWED_CORE_METRICS = ImmutableSet.of(CoreMetrics.GENERATED_LINES, CoreMetrics.NCLOC, CoreMetrics.NCLOC_DATA, CoreMetrics.GENERATED_NCLOC, CoreMetrics.COMMENT_LINES, CoreMetrics.PUBLIC_API, new Metric[]{CoreMetrics.PUBLIC_UNDOCUMENTED_API, CoreMetrics.CLASSES, CoreMetrics.FUNCTIONS, CoreMetrics.STATEMENTS, CoreMetrics.COMPLEXITY, CoreMetrics.COMPLEXITY_IN_CLASSES, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, CoreMetrics.COGNITIVE_COMPLEXITY, CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, CoreMetrics.TESTS, CoreMetrics.SKIPPED_TESTS, CoreMetrics.TEST_ERRORS, CoreMetrics.TEST_FAILURES, CoreMetrics.TEST_EXECUTION_TIME, CoreMetrics.EXECUTABLE_LINES_DATA});
    private final Set<Metric> metrics;

    @Autowired(required=false)
    public ScannerMetrics() {
        this.metrics = ALLOWED_CORE_METRICS;
    }

    @Autowired(required=false)
    public ScannerMetrics(Metrics[] metricsRepositories) {
        this.metrics = Stream.concat(ScannerMetrics.getPluginMetrics(metricsRepositories), ALLOWED_CORE_METRICS.stream()).collect(Collectors.toSet());
    }

    public Set<Metric> getMetrics() {
        return this.metrics;
    }

    private static Stream<Metric> getPluginMetrics(Metrics[] metricsRepositories) {
        return Arrays.stream(metricsRepositories).map(Metrics::getMetrics).filter(Objects::nonNull).flatMap(Collection::stream);
    }
}

