/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.Objects;
import org.sonar.core.sarif.DefaultConfiguration;
import org.sonar.core.sarif.PropertiesBag;
import org.sonar.core.sarif.WrappedText;

public class Rule {
    @SerializedName(value="id")
    private final String id;
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="shortDescription")
    private final WrappedText shortDescription;
    @SerializedName(value="fullDescription")
    private final WrappedText fullDescription;
    @SerializedName(value="help")
    private final WrappedText help;
    @SerializedName(value="properties")
    private final PropertiesBag properties;
    @SerializedName(value="defaultConfiguration")
    private DefaultConfiguration defaultConfiguration;

    private Rule(String id, String name, WrappedText shortDescription, WrappedText fullDescription, WrappedText help, PropertiesBag properties) {
        this.id = id;
        this.name = name;
        this.shortDescription = shortDescription;
        this.fullDescription = fullDescription;
        this.help = help;
        this.properties = properties;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public WrappedText getShortDescription() {
        return this.shortDescription;
    }

    public WrappedText getFullDescription() {
        return this.fullDescription;
    }

    public WrappedText getHelp() {
        return this.help;
    }

    public PropertiesBag getProperties() {
        return this.properties;
    }

    public DefaultConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.id, rule.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static RuleBuilder builder() {
        return new RuleBuilder();
    }

    public static final class RuleBuilder {
        private String id;
        private String name;
        private WrappedText shortDescription;
        private WrappedText fullDescription;
        private WrappedText help;
        private PropertiesBag properties;

        private RuleBuilder() {
        }

        public RuleBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RuleBuilder shortDescription(String shortDescription) {
            this.shortDescription = WrappedText.of(shortDescription);
            return this;
        }

        public RuleBuilder fullDescription(String fullDescription) {
            this.fullDescription = WrappedText.of(fullDescription);
            return this;
        }

        public RuleBuilder help(String help) {
            this.help = WrappedText.of(help);
            return this;
        }

        public RuleBuilder properties(PropertiesBag properties) {
            this.properties = properties;
            return this;
        }

        public Rule build() {
            return new Rule(this.id, this.name, this.shortDescription, this.fullDescription, this.help, this.properties);
        }
    }
}

