/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.gson.annotations.SerializedName;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.core.sarif.Result;
import org.sonar.core.sarif.Tool;

public class Run {
    @SerializedName(value="tool")
    private final Tool tool;
    @SerializedName(value="results")
    private final Set<Result> results;
    @SerializedName(value="language")
    private final String language;
    @SerializedName(value="columnKind")
    private final String columnKind;

    private Run(Tool tool, Set<Result> results, @Nullable String language, @Nullable String columnKind) {
        this.tool = tool;
        this.results = Set.copyOf(results);
        this.language = language;
        this.columnKind = columnKind;
    }

    @CheckForNull
    public String getLanguage() {
        return this.language;
    }

    @CheckForNull
    public String getColumnKind() {
        return this.columnKind;
    }

    public Tool getTool() {
        return this.tool;
    }

    public Set<Result> getResults() {
        return this.results;
    }

    public static RunBuilder builder() {
        return new RunBuilder();
    }

    public static final class RunBuilder {
        private Tool tool;
        private Set<Result> results;
        private String language;
        private String columnKind;

        private RunBuilder() {
        }

        public RunBuilder tool(Tool tool) {
            this.tool = tool;
            return this;
        }

        public RunBuilder results(Set<Result> results) {
            this.results = results;
            return this;
        }

        public RunBuilder language(String language) {
            this.language = language;
            return this;
        }

        public RunBuilder columnKind(String columnKind) {
            this.columnKind = columnKind;
            return this;
        }

        public Run build() {
            return new Run(this.tool, this.results, this.language, this.columnKind);
        }
    }
}

