/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.sarif;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.sarif.Sarif210;
import org.sonar.core.sarif.SarifSerializer;
import org.sonar.core.sarif.SarifVersionValidator;

@ScannerSide
@ComputeEngineSide
public class SarifSerializerImpl
implements SarifSerializer {
    private static final String SARIF_REPORT_ERROR = "Failed to read SARIF report at '%s'";
    private static final String SARIF_JSON_SYNTAX_ERROR = "Failed to read SARIF report at '%s': invalid JSON syntax or file is not UTF-8 encoded";
    private final Gson gson;

    @Inject
    public SarifSerializerImpl() {
        this(new Gson());
    }

    @VisibleForTesting
    SarifSerializerImpl(Gson gson) {
        this.gson = gson;
    }

    @Override
    public String serialize(Sarif210 sarif210) {
        return this.gson.toJson(sarif210);
    }

    @Override
    public Sarif210 deserialize(Path reportPath) throws NoSuchFileException {
        Sarif210 sarif210;
        block10: {
            BufferedReader reader = Files.newBufferedReader(reportPath, StandardCharsets.UTF_8);
            try {
                Sarif210 sarif = this.gson.fromJson((Reader)reader, Sarif210.class);
                SarifVersionValidator.validateSarifVersion(sarif.getVersion());
                sarif210 = sarif;
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw e;
                }
                catch (JsonIOException | IOException e) {
                    throw new IllegalStateException(String.format(SARIF_REPORT_ERROR, reportPath), e);
                }
                catch (JsonSyntaxException e) {
                    throw new IllegalStateException(String.format(SARIF_JSON_SYNTAX_ERROR, reportPath), e);
                }
            }
            ((Reader)reader).close();
        }
        return sarif210;
    }
}

