/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.impl.utils.DefaultTempFolder;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.TempFolder;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.bootstrap.ScannerProperties;
import org.springframework.context.annotation.Bean;

public class GlobalTempFolderProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalTempFolderProvider.class);
    private static final long CLEAN_MAX_AGE = TimeUnit.DAYS.toMillis(21L);
    static final String TMP_NAME_PREFIX = ".sonartmp_";
    private System2 system;

    public GlobalTempFolderProvider() {
        this(new System2());
    }

    GlobalTempFolderProvider(System2 system) {
        this.system = system;
    }

    @Bean(value={"GlobalTempFolder"})
    public TempFolder provide(ScannerProperties scannerProps) {
        String workingPathName = StringUtils.defaultIfBlank(scannerProps.property("sonar.globalWorking.directory"), "");
        Path workingPath = Paths.get(workingPathName, new String[0]);
        if (!workingPath.isAbsolute()) {
            Path home = this.findSonarHome(scannerProps);
            workingPath = home.resolve(workingPath).normalize();
        }
        try {
            GlobalTempFolderProvider.cleanTempFolders(workingPath);
        }
        catch (IOException e) {
            LOG.error(String.format("failed to clean global working directory: %s", workingPath), e);
        }
        Path tempDir = GlobalTempFolderProvider.createTempFolder(workingPath);
        return new DefaultTempFolder(tempDir.toFile(), true);
    }

    private static Path createTempFolder(Path workingPath) {
        try {
            Path realPath = workingPath;
            if (Files.isSymbolicLink(realPath)) {
                realPath = realPath.toRealPath(new LinkOption[0]);
            }
            Files.createDirectories(realPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create working path: " + workingPath, e);
        }
        try {
            return Files.createTempDirectory(workingPath, TMP_NAME_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary folder in " + workingPath, e);
        }
    }

    private Path findSonarHome(ScannerProperties props) {
        String home = props.property("sonar.userHome");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        home = this.system.envVariable("SONAR_USER_HOME");
        if (home != null) {
            return Paths.get(home, new String[0]).toAbsolutePath();
        }
        home = this.system.property("user.home");
        return Paths.get(home, ".sonar").toAbsolutePath();
    }

    private static void cleanTempFolders(Path path) throws IOException {
        if (path.toFile().exists()) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, new CleanFilter());){
                for (Path p : stream) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    private static class CleanFilter
    implements DirectoryStream.Filter<Path> {
        private CleanFilter() {
        }

        @Override
        public boolean accept(Path path) throws IOException {
            BasicFileAttributes attrs;
            if (!path.toFile().exists()) {
                return false;
            }
            if (!path.getFileName().toString().startsWith(GlobalTempFolderProvider.TMP_NAME_PREFIX)) {
                return false;
            }
            long threshold = System.currentTimeMillis() - CLEAN_MAX_AGE;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Couldn't read file attributes for %s : ", path), ioe);
                return false;
            }
            long creationTime = attrs.creationTime().toMillis();
            return creationTime < threshold;
        }
    }
}

