/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.ci;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.MessageException;
import org.sonar.scanner.ci.CiConfiguration;
import org.sonar.scanner.ci.CiVendor;
import org.springframework.context.annotation.Bean;

public class CiConfigurationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CiConfigurationProvider.class);
    private static final String PROP_DISABLED = "sonar.ci.autoconfig.disabled";

    @Bean(value={"CiConfiguration"})
    public CiConfiguration provide(Configuration configuration, CiVendor[] ciVendors) {
        boolean disabled = configuration.getBoolean(PROP_DISABLED).orElse(false);
        if (disabled) {
            return new EmptyCiConfiguration();
        }
        List detectedVendors = Arrays.stream(ciVendors).filter(CiVendor::isDetected).collect(Collectors.toList());
        if (detectedVendors.size() > 1) {
            List names = detectedVendors.stream().map(CiVendor::getName).collect(Collectors.toList());
            throw MessageException.of("Multiple CI environments are detected: " + names + ". Please check environment variables or set property sonar.ci.autoconfig.disabled to true.");
        }
        if (detectedVendors.size() == 1) {
            CiVendor vendor = (CiVendor)detectedVendors.get(0);
            LOG.info("Auto-configuring with CI '{}'", (Object)vendor.getName());
            return vendor.loadConfiguration();
        }
        return new EmptyCiConfiguration();
    }

    static class EmptyCiConfiguration
    implements CiConfiguration {
        EmptyCiConfiguration() {
        }

        @Override
        public Optional<String> getScmRevision() {
            return Optional.empty();
        }

        @Override
        public String getCiName() {
            return "undetected";
        }
    }
}

