/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextPointer;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rules.RuleType;
import org.sonar.scanner.externalissue.ReportParser;

public class ExternalIssueImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalIssueImporter.class);
    private static final int MAX_UNKNOWN_FILE_PATHS_TO_PRINT = 5;
    private final SensorContext context;
    private final ReportParser.Report report;
    private final Set<String> unknownFiles = new LinkedHashSet<String>();
    private final Set<String> knownFiles = new LinkedHashSet<String>();

    public ExternalIssueImporter(SensorContext context, ReportParser.Report report) {
        this.context = context;
        this.report = report;
    }

    public void execute() {
        int issueCount = 0;
        for (ReportParser.Issue issue : this.report.issues) {
            if (!this.importIssue(issue)) continue;
            ++issueCount;
        }
        LOG.info("Imported {} {} in {} {}", issueCount, ExternalIssueImporter.pluralize("issue", issueCount), this.knownFiles.size(), ExternalIssueImporter.pluralize("file", this.knownFiles.size()));
        int numberOfUnknownFiles = this.unknownFiles.size();
        if (numberOfUnknownFiles > 0) {
            LOG.info("External issues ignored for " + numberOfUnknownFiles + " unknown files, including: " + this.unknownFiles.stream().limit(5L).collect(Collectors.joining(", ")));
        }
    }

    private boolean importIssue(ReportParser.Issue issue) {
        NewIssueLocation primary;
        NewExternalIssue externalIssue = this.context.newExternalIssue().engineId(issue.engineId).ruleId(issue.ruleId).severity(Severity.valueOf(issue.severity)).type(RuleType.valueOf(issue.type));
        if (issue.effortMinutes != null) {
            externalIssue.remediationEffortMinutes((long)issue.effortMinutes);
        }
        if ((primary = ExternalIssueImporter.fillLocation(this.context, externalIssue.newLocation(), issue.primaryLocation)) != null) {
            this.knownFiles.add(issue.primaryLocation.filePath);
            externalIssue.at(primary);
            if (issue.secondaryLocations != null) {
                for (ReportParser.Location l : issue.secondaryLocations) {
                    NewIssueLocation secondary = ExternalIssueImporter.fillLocation(this.context, externalIssue.newLocation(), l);
                    if (secondary == null) continue;
                    externalIssue.addLocation(secondary);
                }
            }
            externalIssue.save();
            return true;
        }
        this.unknownFiles.add(issue.primaryLocation.filePath);
        return false;
    }

    private static String pluralize(String msg, int count) {
        if (count == 1) {
            return msg;
        }
        return msg + "s";
    }

    @CheckForNull
    private static NewIssueLocation fillLocation(SensorContext context, NewIssueLocation newLocation, ReportParser.Location location) {
        InputFile file = ExternalIssueImporter.findFile(context, location.filePath);
        if (file == null) {
            return null;
        }
        newLocation.on(file);
        if (location.message != null) {
            newLocation.message(location.message);
        }
        if (location.textRange != null) {
            if (location.textRange.startColumn != null) {
                TextPointer start = file.newPointer(location.textRange.startLine, location.textRange.startColumn);
                int endLine = location.textRange.endLine != null ? location.textRange.endLine : location.textRange.startLine;
                int endColumn = location.textRange.endColumn == null ? file.selectLine(endLine).end().lineOffset() : location.textRange.endColumn.intValue();
                TextPointer end = file.newPointer(endLine, endColumn);
                newLocation.at(file.newRange(start, end));
            } else {
                newLocation.at(file.selectLine(location.textRange.startLine));
            }
        }
        return newLocation;
    }

    @CheckForNull
    private static InputFile findFile(SensorContext context, String filePath) {
        return context.fileSystem().inputFile(context.fileSystem().predicates().hasPath(filePath));
    }
}

