/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.externalissue.sarif;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.core.sarif.Region;

@ScannerSide
public class RegionMapper {
    Optional<TextRange> mapRegion(@Nullable Region region, InputFile file) {
        int endColumn;
        int startColumn;
        int endLine;
        if (region == null) {
            return Optional.empty();
        }
        int startLine = Objects.requireNonNull(region.getStartLine(), "No start line defined for the region.");
        if (RegionMapper.rangeIsEmpty(startLine, endLine = Optional.ofNullable(region.getEndLine()).orElse(startLine).intValue(), startColumn = Optional.ofNullable(region.getStartColumn()).map(RegionMapper::adjustSarifColumnIndexToSqIndex).orElse(0).intValue(), endColumn = Optional.ofNullable(region.getEndColumn()).map(RegionMapper::adjustSarifColumnIndexToSqIndex).orElseGet(() -> file.selectLine(endLine).end().lineOffset()).intValue())) {
            return Optional.of(file.selectLine(startLine));
        }
        return Optional.of(file.newRange(startLine, startColumn, endLine, endColumn));
    }

    private static int adjustSarifColumnIndexToSqIndex(int index) {
        return index - 1;
    }

    private static boolean rangeIsEmpty(int startLine, int endLine, int startColumn, int endColumn) {
        return startLine == endLine && startColumn == endColumn;
    }
}

