/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.repository;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.repository.NewCodePeriodLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;
import org.sonarqube.ws.NewCodePeriods;

public class ReferenceBranchSupplier {
    private static final Logger LOG = Loggers.get(ReferenceBranchSupplier.class);
    private static final String LOG_MSG_WS = "Load New Code definition";
    private static final String NEW_CODE_PARAM_KEY = "sonar.newCode.referenceBranch";
    private final Configuration configuration;
    private final NewCodePeriodLoader newCodePeriodLoader;
    private final BranchConfiguration branchConfiguration;
    private final DefaultInputProject project;
    private final ProjectBranches branches;

    public ReferenceBranchSupplier(Configuration configuration, NewCodePeriodLoader newCodePeriodLoader, BranchConfiguration branchConfiguration, DefaultInputProject project, ProjectBranches branches) {
        this.configuration = configuration;
        this.newCodePeriodLoader = newCodePeriodLoader;
        this.branchConfiguration = branchConfiguration;
        this.project = project;
        this.branches = branches;
    }

    @CheckForNull
    public String get() {
        if (this.branchConfiguration.isPullRequest() || this.branches.isEmpty()) {
            return null;
        }
        return Optional.ofNullable(this.getFromProperties()).orElseGet(this::loadWs);
    }

    private String loadWs() {
        String branchName = this.getBranchName();
        Profiler profiler = Profiler.create(LOG).startInfo(LOG_MSG_WS);
        NewCodePeriods.ShowWSResponse newCode = this.newCodePeriodLoader.load(this.project.key(), branchName);
        profiler.stopInfo();
        if (newCode.getType() != NewCodePeriods.NewCodePeriodType.REFERENCE_BRANCH) {
            return null;
        }
        String referenceBranchName = newCode.getValue();
        if (branchName.equals(referenceBranchName)) {
            LOG.warn("New Code reference branch is set to the branch being analyzed. Skipping the computation of New Code");
            return null;
        }
        return referenceBranchName;
    }

    @CheckForNull
    public String getFromProperties() {
        if (this.branchConfiguration.isPullRequest() || this.branches.isEmpty()) {
            return null;
        }
        Optional<String> value = this.configuration.get(NEW_CODE_PARAM_KEY);
        if (value.isPresent()) {
            String referenceBranchName = value.get();
            if (referenceBranchName.equals(this.getBranchName())) {
                throw new IllegalStateException(String.format("Reference branch set with '%s' points to the current branch '%s'", NEW_CODE_PARAM_KEY, referenceBranchName));
            }
            return referenceBranchName;
        }
        return null;
    }

    private String getBranchName() {
        return this.branchConfiguration.branchName() != null ? this.branchConfiguration.branchName() : this.branches.defaultBranchName();
    }
}

