/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Objects;
import org.sonar.api.batch.fs.internal.AbstractProjectOrModule;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.batch.fs.internal.DefaultInputProject;
import org.sonar.core.util.FileUtils;
import org.sonar.scanner.fs.InputModuleHierarchy;

public class WorkDirectoriesInitializer {
    public void execute(InputModuleHierarchy moduleHierarchy) {
        DefaultInputModule root = moduleHierarchy.root();
        for (DefaultInputModule sub : moduleHierarchy.children(root)) {
            if (Objects.equals(root.getWorkDir(), sub.getWorkDir())) continue;
            WorkDirectoriesInitializer.cleanAllWorkingDirs(moduleHierarchy, sub);
            WorkDirectoriesInitializer.mkdirsAllWorkingDirs(moduleHierarchy, sub);
        }
    }

    public void execute(DefaultInputProject project) {
        WorkDirectoriesInitializer.cleanWorkingDir(project);
        WorkDirectoriesInitializer.mkdirWorkingDir(project);
    }

    private static void cleanAllWorkingDirs(InputModuleHierarchy moduleHierarchy, DefaultInputModule module) {
        for (DefaultInputModule sub : moduleHierarchy.children(module)) {
            WorkDirectoriesInitializer.cleanAllWorkingDirs(moduleHierarchy, sub);
        }
        WorkDirectoriesInitializer.cleanWorkingDir(module);
    }

    private static void cleanWorkingDir(AbstractProjectOrModule projectOrModule) {
        if (Files.exists(projectOrModule.getWorkDir(), new LinkOption[0])) {
            WorkDirectoriesInitializer.deleteAllRecursivelyExceptLockFile(projectOrModule.getWorkDir());
        }
    }

    private static void mkdirsAllWorkingDirs(InputModuleHierarchy moduleHierarchy, DefaultInputModule module) {
        for (DefaultInputModule sub : moduleHierarchy.children(module)) {
            WorkDirectoriesInitializer.mkdirsAllWorkingDirs(moduleHierarchy, sub);
        }
        WorkDirectoriesInitializer.mkdirWorkingDir(module);
    }

    private static void mkdirWorkingDir(AbstractProjectOrModule projectOrModule) {
        try {
            Files.createDirectories(projectOrModule.getWorkDir(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to create working dir: " + projectOrModule.getWorkDir(), e);
        }
    }

    private static void deleteAllRecursivelyExceptLockFile(Path dirToDelete) {
        try (DirectoryStream<Path> stream = WorkDirectoriesInitializer.list(dirToDelete);){
            Iterator<Path> it = stream.iterator();
            while (it.hasNext()) {
                FileUtils.deleteQuietly(it.next().toFile());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to clean working directory: " + dirToDelete.toString(), e);
        }
    }

    private static DirectoryStream<Path> list(Path dir) throws IOException {
        return Files.newDirectoryStream(dir, entry -> !".sonar_lock".equals(entry.getFileName().toString()));
    }
}

