/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.filesystem;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.utils.WildcardPattern;

@Immutable
public abstract class AbstractCoverageAndDuplicationExclusions {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCoverageAndDuplicationExclusions.class);
    private final Function<DefaultInputFile, String> pathExtractor;
    private final String[] coverageExclusionConfig;
    private final String[] duplicationExclusionConfig;
    private final Collection<WildcardPattern> coverageExclusionPatterns;
    private final Collection<WildcardPattern> duplicationExclusionPatterns;

    public AbstractCoverageAndDuplicationExclusions(Function<String, String[]> configProvider, Function<DefaultInputFile, String> pathExtractor) {
        this.pathExtractor = pathExtractor;
        this.coverageExclusionConfig = configProvider.apply("sonar.coverage.exclusions");
        this.coverageExclusionPatterns = Stream.of(this.coverageExclusionConfig).map(WildcardPattern::create).collect(Collectors.toList());
        this.duplicationExclusionConfig = configProvider.apply("sonar.cpd.exclusions");
        this.duplicationExclusionPatterns = Stream.of(this.duplicationExclusionConfig).map(WildcardPattern::create).collect(Collectors.toList());
    }

    public String[] getCoverageExclusionConfig() {
        return this.coverageExclusionConfig;
    }

    public String[] getDuplicationExclusionConfig() {
        return this.duplicationExclusionConfig;
    }

    void log(String indent) {
        if (!this.coverageExclusionPatterns.isEmpty()) {
            AbstractCoverageAndDuplicationExclusions.log("Excluded sources for coverage:", this.coverageExclusionPatterns, indent);
        }
        if (!this.duplicationExclusionPatterns.isEmpty()) {
            AbstractCoverageAndDuplicationExclusions.log("Excluded sources for duplication:", this.duplicationExclusionPatterns, indent);
        }
    }

    public boolean isExcludedForCoverage(DefaultInputFile file) {
        return this.isExcluded(file, this.coverageExclusionPatterns);
    }

    public boolean isExcludedForDuplication(DefaultInputFile file) {
        return this.isExcluded(file, this.duplicationExclusionPatterns);
    }

    private boolean isExcluded(DefaultInputFile file, Collection<WildcardPattern> patterns) {
        if (patterns.isEmpty()) {
            return false;
        }
        String path = this.pathExtractor.apply(file);
        return patterns.stream().anyMatch(p -> p.match(path));
    }

    private static void log(String title, Collection<WildcardPattern> patterns, String ident) {
        if (!patterns.isEmpty()) {
            LOG.info("{}{} {}", ident, title, patterns.stream().map(WildcardPattern::toString).collect(Collectors.joining(", ")));
        }
    }
}

